/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.cfg.LiveVariablesAnalysis;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.cfg.ControlFlowGraph;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1854")
public class DeadStoreCheck
extends PHPSubscriptionCheck {
    private static final Set<String> BASIC_LITERAL_VALUES = Set.of("true", "false", "1", "0", "0.0", "-1", "null", "''", "array()", "[]", "\"\"");
    private static final String MESSAGE_TEMPLATE = "Remove this useless assignment to local variable '%s'.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.METHOD_DECLARATION);
    }

    @Override
    public void visitNode(Tree tree) {
        ControlFlowGraph cfg = ControlFlowGraph.build(tree, this.context());
        if (cfg == null) {
            return;
        }
        Scope scope = this.context().symbolTable().getScopeFor(tree);
        if (scope == null || scope.hasUnresolvedCompact()) {
            return;
        }
        if (DeadStoreCheck.containsTryCatchBlock(tree)) {
            return;
        }
        LiveVariablesAnalysis lva = LiveVariablesAnalysis.analyze(cfg, this.context().symbolTable());
        cfg.blocks().forEach(block -> this.verifyBlock((CfgBlock)block, lva.getLiveVariables((CfgBlock)block), lva.getReadSymbols()));
    }

    private static boolean containsTryCatchBlock(Tree tree) {
        TryVisitor tryVisitor = new TryVisitor();
        tree.accept(tryVisitor);
        return tryVisitor.hasTry;
    }

    private void verifyBlock(CfgBlock block, LiveVariablesAnalysis.LiveVariables blockLiveVariables, Set<Symbol> readSymbols) {
        HashSet<Symbol> willBeRead = new HashSet<Symbol>(blockLiveVariables.getOut());
        for (Tree element : ListUtils.reverse(block.elements())) {
            Map<Symbol, LiveVariablesAnalysis.VariableUsage> usagesInElement = blockLiveVariables.getVariableUsages(element);
            for (Map.Entry<Symbol, LiveVariablesAnalysis.VariableUsage> symbolWithUsage : usagesInElement.entrySet()) {
                Symbol symbol = symbolWithUsage.getKey();
                if (DeadStoreCheck.outOfScope(readSymbols, symbol)) continue;
                LiveVariablesAnalysis.VariableUsage usage = symbolWithUsage.getValue();
                if (usage.isWrite() && !usage.isRead()) {
                    if (!willBeRead.contains(symbol) && !DeadStoreCheck.shouldSkip(element, symbol)) {
                        this.context().newIssue(this, element, String.format(MESSAGE_TEMPLATE, symbol.name()));
                    }
                    willBeRead.remove(symbol);
                    continue;
                }
                if (!usage.isRead()) continue;
                willBeRead.add(symbol);
            }
        }
    }

    private static boolean outOfScope(Set<Symbol> readSymbols, Symbol symbol) {
        return !readSymbols.contains(symbol) || symbol.is(Symbol.Kind.PARAMETER);
    }

    private static boolean shouldSkip(Tree element, Symbol symbol) {
        return symbol.hasModifier("static") || symbol.hasModifier("global") || DeadStoreCheck.isInitializedToBasicValue(element) || DeadStoreCheck.isReferenceValue(symbol);
    }

    private static boolean isReferenceValue(Symbol symbol) {
        return symbol.declaration().getParent().is(Tree.Kind.REFERENCE_VARIABLE, Tree.Kind.ASSIGNMENT_BY_REFERENCE) || symbol.usages().stream().map(Tree::getParent).map(Tree::getParent).anyMatch(t -> t.is(Tree.Kind.ASSIGNMENT_BY_REFERENCE));
    }

    private static boolean isInitializedToBasicValue(Tree element) {
        if (!element.is(Tree.Kind.EXPRESSION_STATEMENT)) {
            return false;
        }
        ExpressionTree inner = ((ExpressionStatementTree)element).expression();
        if (!inner.is(Tree.Kind.ASSIGNMENT)) {
            return false;
        }
        ExpressionTree rightmostValue = DeadStoreCheck.extractRightmostValue((AssignmentExpressionTree)inner);
        return BASIC_LITERAL_VALUES.contains(rightmostValue.toString().toLowerCase(Locale.ENGLISH));
    }

    private static ExpressionTree extractRightmostValue(AssignmentExpressionTree assignment) {
        AssignmentExpressionTree rightMostAssignment = assignment;
        ExpressionTree rightValue = rightMostAssignment.value();
        while (rightValue.is(Tree.Kind.ASSIGNMENT)) {
            rightMostAssignment = (AssignmentExpressionTree)rightValue;
            rightValue = rightMostAssignment.value();
        }
        return rightValue;
    }

    private static class TryVisitor
    extends PHPVisitorCheck {
        private boolean hasTry;

        private TryVisitor() {
        }

        @Override
        public void visitTryStatement(TryStatementTree tree) {
            this.hasTry = true;
        }
    }
}

