/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ArrayAccessTreeImpl
extends PHPTree
implements ArrayAccessTree {
    private static final Tree.Kind KIND = Tree.Kind.ARRAY_ACCESS;
    private ExpressionTree object;
    private final InternalSyntaxToken openBraceToken;
    @Nullable
    private final ExpressionTree offset;
    private final InternalSyntaxToken closeBraceToken;

    public ArrayAccessTreeImpl(InternalSyntaxToken openBraceToken, ExpressionTree offset, InternalSyntaxToken closeBraceToken) {
        this.openBraceToken = openBraceToken;
        this.offset = offset;
        this.closeBraceToken = closeBraceToken;
    }

    public ArrayAccessTreeImpl(InternalSyntaxToken openBraceToken, InternalSyntaxToken closeBraceToken) {
        this.openBraceToken = openBraceToken;
        this.offset = null;
        this.closeBraceToken = closeBraceToken;
    }

    public ArrayAccessTree complete(ExpressionTree object) {
        this.object = object;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public ExpressionTree object() {
        return this.object;
    }

    @Override
    public SyntaxToken openBraceToken() {
        return this.openBraceToken;
    }

    @Override
    @Nullable
    public ExpressionTree offset() {
        return this.offset;
    }

    @Override
    public SyntaxToken closeBraceToken() {
        return this.closeBraceToken;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.iteratorOf(this.object, this.openBraceToken, this.offset, this.closeBraceToken);
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitArrayAccess(this);
    }
}

