/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.predicate;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ExecutableHint;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.MethodIntrospector;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectionHintsPredicates {
    ReflectionHintsPredicates() {
    }

    public TypeHintPredicate onType(TypeReference typeReference) {
        Assert.notNull((Object)typeReference, "'typeReference' must not be null");
        return new TypeHintPredicate(typeReference);
    }

    public TypeHintPredicate onType(Class<?> type) {
        Assert.notNull(type, "'type' must not be null");
        return new TypeHintPredicate(TypeReference.of(type));
    }

    @Deprecated(since="7.0", forRemoval=true)
    public ConstructorHintPredicate onConstructor(Constructor<?> constructor) {
        Assert.notNull(constructor, "'constructor' must not be null");
        return new ConstructorHintPredicate(constructor);
    }

    public Predicate<RuntimeHints> onConstructorInvocation(Constructor<?> constructor) {
        Assert.notNull(constructor, "'constructor' must not be null");
        return new ConstructorHintPredicate(constructor).invoke();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public MethodHintPredicate onMethod(Method method) {
        Assert.notNull((Object)method, "'method' must not be null");
        return new MethodHintPredicate(method);
    }

    public Predicate<RuntimeHints> onMethodInvocation(Method method) {
        Assert.notNull((Object)method, "'method' must not be null");
        return new MethodHintPredicate(method).invoke();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public MethodHintPredicate onMethod(Class<?> type, String methodName) {
        Assert.notNull(type, "'type' must not be null");
        Assert.hasText(methodName, "'methodName' must not be empty");
        return new MethodHintPredicate(this.getMethod(type, methodName));
    }

    public Predicate<RuntimeHints> onMethodInvocation(Class<?> type, String methodName) {
        Assert.notNull(type, "'type' must not be null");
        Assert.hasText(methodName, "'methodName' must not be empty");
        return new MethodHintPredicate(this.getMethod(type, methodName)).invoke();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public MethodHintPredicate onMethod(String className, String methodName) throws ClassNotFoundException {
        Assert.hasText(className, "'className' must not be empty");
        Assert.hasText(methodName, "'methodName' must not be empty");
        return this.onMethod(Class.forName(className), methodName);
    }

    public Predicate<RuntimeHints> onMethodInvocation(String className, String methodName) throws ClassNotFoundException {
        Assert.hasText(className, "'className' must not be empty");
        Assert.hasText(methodName, "'methodName' must not be empty");
        return this.onMethod(Class.forName(className), methodName).invoke();
    }

    private Method getMethod(Class<?> type, String methodName) {
        ReflectionUtils.MethodFilter selector = method -> methodName.equals(method.getName());
        Set<Method> methods = MethodIntrospector.selectMethods(type, selector);
        if (methods.size() == 1) {
            return methods.iterator().next();
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException("Found multiple methods named '%s' on class %s".formatted(methodName, type.getName()));
        }
        throw new IllegalArgumentException("No method named '%s' on class %s".formatted(methodName, type.getName()));
    }

    @Deprecated(since="7.0", forRemoval=true)
    public Predicate<RuntimeHints> onField(Class<?> type, String fieldName) {
        return this.onFieldAccess(type, fieldName);
    }

    public Predicate<RuntimeHints> onFieldAccess(Class<?> type, String fieldName) {
        Assert.notNull(type, "'type' must not be null");
        Assert.hasText(fieldName, "'fieldName' must not be empty");
        Field field = ReflectionUtils.findField(type, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("No field named '%s' on class %s".formatted(fieldName, type.getName()));
        }
        return new FieldHintPredicate(field);
    }

    @Deprecated(since="7.0", forRemoval=true)
    public Predicate<RuntimeHints> onField(String className, String fieldName) throws ClassNotFoundException {
        return this.onFieldAccess(className, fieldName);
    }

    public Predicate<RuntimeHints> onFieldAccess(String className, String fieldName) throws ClassNotFoundException {
        Assert.hasText(className, "'className' must not be empty");
        Assert.hasText(fieldName, "'fieldName' must not be empty");
        return this.onFieldAccess(Class.forName(className), fieldName);
    }

    @Deprecated(since="7.0", forRemoval=true)
    public Predicate<RuntimeHints> onField(Field field) {
        return this.onFieldAccess(field);
    }

    public Predicate<RuntimeHints> onFieldAccess(Field field) {
        Assert.notNull((Object)field, "'field' must not be null");
        return new FieldHintPredicate(field);
    }

    public static class TypeHintPredicate
    implements Predicate<RuntimeHints> {
        private final TypeReference type;

        TypeHintPredicate(TypeReference type) {
            this.type = type;
        }

        private @Nullable TypeHint getTypeHint(RuntimeHints hints) {
            return hints.reflection().getTypeHint(this.type);
        }

        @Override
        public boolean test(RuntimeHints hints) {
            return this.getTypeHint(hints) != null;
        }

        public Predicate<RuntimeHints> withMemberCategory(MemberCategory memberCategory) {
            Assert.notNull((Object)memberCategory, "'memberCategory' must not be null");
            return this.and(hints -> {
                TypeHint hint = this.getTypeHint((RuntimeHints)hints);
                return hint != null && hint.getMemberCategories().contains((Object)memberCategory);
            });
        }

        public Predicate<RuntimeHints> withMemberCategories(MemberCategory ... memberCategories) {
            Assert.notEmpty((Object[])memberCategories, "'memberCategories' must not be empty");
            return this.and(hints -> {
                TypeHint hint = this.getTypeHint((RuntimeHints)hints);
                return hint != null && hint.getMemberCategories().containsAll(Arrays.asList(memberCategories));
            });
        }

        public Predicate<RuntimeHints> withAnyMemberCategory(MemberCategory ... memberCategories) {
            Assert.notEmpty((Object[])memberCategories, "'memberCategories' must not be empty");
            return this.and(hints -> {
                TypeHint hint = this.getTypeHint((RuntimeHints)hints);
                return hint != null && Arrays.stream(memberCategories).anyMatch(memberCategory -> hint.getMemberCategories().contains(memberCategory));
            });
        }
    }

    @Deprecated(since="7.0", forRemoval=true)
    public static class ConstructorHintPredicate
    extends ExecutableHintPredicate<Constructor<?>> {
        ConstructorHintPredicate(Constructor<?> constructor) {
            super(constructor);
        }

        @Override
        public boolean test(RuntimeHints runtimeHints) {
            return new TypeHintPredicate(TypeReference.of(((Constructor)this.executable).getDeclaringClass())).and(hints -> this.executableMode == ExecutableMode.INTROSPECT).or(new TypeHintPredicate(TypeReference.of(((Constructor)this.executable).getDeclaringClass())).withMemberCategory(MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS).and(hints -> Modifier.isPublic(((Constructor)this.executable).getModifiers())).and(hints -> this.executableMode == ExecutableMode.INVOKE)).or(new TypeHintPredicate(TypeReference.of(((Constructor)this.executable).getDeclaringClass())).withMemberCategory(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS).and(hints -> this.executableMode == ExecutableMode.INVOKE)).or(this.exactMatch()).test(runtimeHints);
        }

        @Override
        Predicate<RuntimeHints> exactMatch() {
            return hints -> {
                TypeHint hint = hints.reflection().getTypeHint(((Constructor)this.executable).getDeclaringClass());
                return hint != null && hint.constructors().anyMatch(executableHint -> {
                    List<TypeReference> parameters = TypeReference.listOf(((Constructor)this.executable).getParameterTypes());
                    return ConstructorHintPredicate.includes(executableHint, "<init>", parameters, this.executableMode);
                });
            };
        }
    }

    @Deprecated(since="7.0", forRemoval=true)
    public static abstract class ExecutableHintPredicate<T extends Executable>
    implements Predicate<RuntimeHints> {
        protected final T executable;
        protected ExecutableMode executableMode = ExecutableMode.INTROSPECT;

        ExecutableHintPredicate(T executable) {
            this.executable = executable;
        }

        public ExecutableHintPredicate<T> introspect() {
            this.executableMode = ExecutableMode.INTROSPECT;
            return this;
        }

        public ExecutableHintPredicate<T> invoke() {
            this.executableMode = ExecutableMode.INVOKE;
            return this;
        }

        abstract Predicate<RuntimeHints> exactMatch();

        static boolean includes(ExecutableHint hint, String name, List<TypeReference> parameterTypes, ExecutableMode executableModes) {
            return hint.getName().equals(name) && hint.getParameterTypes().equals(parameterTypes) && (hint.getMode().equals((Object)ExecutableMode.INVOKE) || !executableModes.equals((Object)ExecutableMode.INVOKE));
        }
    }

    @Deprecated(since="7.0", forRemoval=true)
    public static class MethodHintPredicate
    extends ExecutableHintPredicate<Method> {
        MethodHintPredicate(Method method) {
            super(method);
        }

        @Override
        public boolean test(RuntimeHints runtimeHints) {
            return new TypeHintPredicate(TypeReference.of(((Method)this.executable).getDeclaringClass())).and(hints -> this.executableMode == ExecutableMode.INTROSPECT).or(new TypeHintPredicate(TypeReference.of(((Method)this.executable).getDeclaringClass())).withMemberCategory(MemberCategory.INVOKE_PUBLIC_METHODS).and(hints -> Modifier.isPublic(((Method)this.executable).getModifiers())).and(hints -> this.executableMode == ExecutableMode.INVOKE)).or(new TypeHintPredicate(TypeReference.of(((Method)this.executable).getDeclaringClass())).withMemberCategory(MemberCategory.INVOKE_DECLARED_METHODS).and(hints -> !Modifier.isPublic(((Method)this.executable).getModifiers())).and(hints -> this.executableMode == ExecutableMode.INVOKE)).or(this.exactMatch()).test(runtimeHints);
        }

        @Override
        Predicate<RuntimeHints> exactMatch() {
            return hints -> {
                TypeHint hint = hints.reflection().getTypeHint(((Method)this.executable).getDeclaringClass());
                return hint != null && hint.methods().anyMatch(executableHint -> {
                    List<TypeReference> parameters = TypeReference.listOf(((Method)this.executable).getParameterTypes());
                    return MethodHintPredicate.includes(executableHint, ((Method)this.executable).getName(), parameters, this.executableMode);
                });
            };
        }
    }

    @Deprecated(since="7.0", forRemoval=true)
    public static class FieldHintPredicate
    implements Predicate<RuntimeHints> {
        private final Field field;

        FieldHintPredicate(Field field) {
            this.field = field;
        }

        @Override
        public boolean test(RuntimeHints runtimeHints) {
            TypeHint typeHint = runtimeHints.reflection().getTypeHint(this.field.getDeclaringClass());
            if (typeHint == null) {
                return false;
            }
            return this.memberCategoryMatch(typeHint) || this.exactMatch(typeHint);
        }

        private boolean memberCategoryMatch(TypeHint typeHint) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                return typeHint.getMemberCategories().contains((Object)MemberCategory.ACCESS_PUBLIC_FIELDS) || typeHint.getMemberCategories().contains((Object)MemberCategory.PUBLIC_FIELDS);
            }
            return typeHint.getMemberCategories().contains((Object)MemberCategory.ACCESS_DECLARED_FIELDS) || typeHint.getMemberCategories().contains((Object)MemberCategory.DECLARED_FIELDS);
        }

        private boolean exactMatch(TypeHint typeHint) {
            return typeHint.fields().anyMatch(fieldHint -> this.field.getName().equals(fieldHint.getName()));
        }
    }
}

