/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import com.google.common.base.CharMatcher;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.simulink.model.SimulinkMatrix;

public class SimulinkMatrixFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static SimulinkMatrix createMatrixFromValue(String value, boolean vectorAs1D) {
        if (!value.startsWith("[")) {
            return new SimulinkMatrix(-1L, -1L);
        }
        long rows = value.contains(String.valueOf(';')) ? (long)(CharMatcher.is((char)';').countIn((CharSequence)value) + 1) : -1L;
        String[] split = StringUtils.split((String)value, (char)';');
        long columns = split[0].contains(",") ? (long)(StringUtils.countMatches((CharSequence)split[0], (CharSequence)",") + 1) : (long)(StringUtils.countMatches((CharSequence)split[0], (CharSequence)" ") + 1);
        if (vectorAs1D && (columns == 1L || rows == 1L)) {
            return new SimulinkMatrix(columns, rows);
        }
        return new SimulinkMatrix(rows, columns);
    }

    public static Set<SimulinkMatrix> createMatrixFromValues(Set<String> values, boolean vectorAs1D) {
        HashSet<SimulinkMatrix> result = new HashSet<SimulinkMatrix>();
        for (String value : values) {
            result.add(SimulinkMatrixFactory.createMatrixFromValue(value, vectorAs1D));
        }
        return result;
    }

    public static SimulinkMatrix createMatrixFromDimensions(String value) {
        if (value == null) {
            return null;
        }
        if (value.equals("")) {
            return new SimulinkMatrix(-1L, -1L);
        }
        value = StringUtils.remove((String)value, (String)"[");
        value = StringUtils.remove((String)value, (String)"]");
        String[] split = StringUtils.split((String)value, (String)" ");
        try {
            long rows = Long.parseLong(split[0]);
            long columns = -1L;
            if (split.length > 1) {
                columns = Long.parseLong(split[1]);
            }
            return new SimulinkMatrix(rows, columns);
        }
        catch (NumberFormatException exception) {
            LOGGER.error("Cannot parse dimension. Expected numbers, but got " + value);
            return new SimulinkMatrix(-1L, -1L);
        }
    }
}

