/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IStringKeyIndex<T> {
    public @Nullable T getValue(@NonNull String var1) throws StorageException;

    @Contract(value="_, true -> !null")
    public T getValue(@NonNull String var1, boolean var2) throws StorageException;

    public List<@Nullable T> getValues(List<@NonNull String> var1) throws StorageException;

    public List<@Nullable T> getValues(List<@NonNull String> var1, boolean var2) throws StorageException;

    public void setValue(@NonNull String var1, @NonNull T var2) throws StorageException;

    public void setValues(PairList<@NonNull String, @NonNull T> var1) throws StorageException;

    public void setOrMergeValues(PairList<@NonNull String, @NonNull T> var1, BinaryOperator<T> var2) throws StorageException;

    public void setOrMergeValue(@NonNull String var1, @NonNull T var2, BinaryOperator<T> var3) throws StorageException;

    public void removeValue(@NonNull String var1) throws StorageException;

    public void removeValues(Collection<@NonNull String> var1) throws StorageException;

    default public Map<String, @NonNull T> getValuesByKeys(Collection<@NonNull String> keys) throws StorageException {
        return this.getValuesByKeys((Set<String>)new HashSet<String>(keys));
    }

    default public Map<String, @NonNull T> getValuesByKeys(Set<@NonNull String> keys) throws StorageException {
        ArrayList<String> keyList = new ArrayList<String>(keys);
        List<T> values = this.getValues(keyList);
        HashMap<String, T> result = HashMap.newHashMap(keyList.size());
        for (int i = 0; i < keyList.size(); ++i) {
            if (values.get(i) == null) continue;
            result.put((String)keyList.get(i), values.get(i));
        }
        return result;
    }

    public List<String> getAllKeys() throws StorageException;

    public List<String> getKeysStartingWith(@NonNull String var1) throws StorageException;

    public PairList<String, T> getAllEntries() throws StorageException;

    public PairList<String, T> getEntriesStartingWith(@NonNull String var1) throws StorageException;

    public PairList<String, T> getEntriesStartingWith(List<@NonNull String> var1) throws StorageException;

    public Set<String> getContainedKeys(List<@NonNull String> var1) throws StorageException;
}

