/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.lib.commons.string.StringUtils;

public class MapAccessorOperand
implements IAttributeOperand {
    private final String mapAttributeName;
    private final List<String> arguments;

    public MapAccessorOperand(String mapAttributeName, List<String> arguments) {
        this.mapAttributeName = mapAttributeName;
        this.arguments = arguments;
    }

    @Override
    public <T> Function<T, Object> getValueAccessor(ICompilationContext<T> context) throws QueryCompilationException {
        Function accessor = context.getAttributeAccessor(this.mapAttributeName);
        EKeyedObjectType targetType = this.getType(context);
        Pattern pattern = this.buildPatternFromArguments();
        return object -> {
            String serializedMap = (String)accessor.apply(object);
            List mapEntries = StringUtils.splitToList((String)serializedMap, (String)",");
            return mapEntries.stream().map(e -> e.split("=", 2)).filter(split -> pattern.matcher(split[0]).matches()).map(split -> MapAccessorOperand.convertToTargetType(split[1], targetType)).collect(Collectors.toList());
        };
    }

    @Override
    public <T> Predicate<T> getValueEqualsIgnoreCasePredicate(ICompilationContext<T> context, Object comparisonValue, boolean lenient) throws QueryCompilationException {
        Function valueAccessor = this.getValueAccessor(context);
        return object -> valueAccessor.andThen(comparisonValue::equals).apply(object);
    }

    private static Object convertToTargetType(String stringValue, EKeyedObjectType targetType) {
        if (targetType == EKeyedObjectType.NUMBER_LIST) {
            return Long.parseLong(stringValue);
        }
        return stringValue;
    }

    private Pattern buildPatternFromArguments() throws QueryCompilationException {
        if (this.arguments.isEmpty()) {
            return Pattern.compile(".*");
        }
        String regex = "(" + String.join((CharSequence)")|(", this.arguments) + ")";
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new QueryCompilationException("Invalid regex " + regex + ": " + e.getMessage(), this.arguments.get(0));
        }
    }

    @Override
    public <T> EKeyedObjectType getType(ICompilationContext<T> context) throws QueryCompilationException {
        EKeyedObjectType attributeType = context.getAttributeType(this.mapAttributeName);
        if (attributeType == EKeyedObjectType.STRING_MAP) {
            return EKeyedObjectType.STRING_LIST;
        }
        if (attributeType == EKeyedObjectType.NUMBER_MAP) {
            return EKeyedObjectType.NUMBER_LIST;
        }
        throw new QueryCompilationException("Tried to call function signature on " + this.mapAttributeName + " for non-map type: " + String.valueOf((Object)attributeType), this.mapAttributeName);
    }

    public String toString() {
        return this.mapAttributeName + "(" + String.join((CharSequence)",", this.arguments) + ")";
    }
}

