/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.branched.BranchCommitReadingStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.Nullable;

final class CommitLayerMerger {
    private static final Comparator<byte[]> BYTE_ARRAY_COMPARATOR = UnsignedBytes.lexicographicalComparator();
    private static final Comparator<Queue<Pair<byte[], byte[]>>> QUEUE_COMPARATOR = Comparator.comparing(q -> (byte[])((Pair)q.peek()).getFirst(), BYTE_ARRAY_COMPARATOR);
    private final List<Queue<Pair<byte[], byte[]>>> queuedEntries;
    private byte[] lastProcessedKey;
    private final boolean preserveValue;
    private final List<byte[]> keys = new ArrayList<byte[]>();
    private final List<byte[]> values = new ArrayList<byte[]>();
    private final List<Integer> valueIndexesThatNeedDeduplication = new ArrayList<Integer>();

    CommitLayerMerger(int numberOfCommits, boolean preserveValue) {
        this.queuedEntries = CollectionUtils.repeat(index -> new LinkedList(), (int)numberOfCommits);
        this.preserveValue = preserveValue;
    }

    public synchronized void flush() {
        this.emitEntries(true);
    }

    public synchronized void appendEntry(int commitIndex, byte[] key, byte[] value) {
        this.queuedEntries.get(commitIndex).add((Pair<byte[], byte[]>)new Pair((Object)key, (Object)value));
        this.emitEntries(false);
    }

    private void emitEntries(boolean endOfScanReached) {
        Queue<Pair<byte[], byte[]>> queueWithSmallestEntry;
        while ((queueWithSmallestEntry = this.getQueueWithSmallestEntry(endOfScanReached)) != null) {
            Pair<byte[], byte[]> smallestEntry = queueWithSmallestEntry.poll();
            if (this.lastProcessedKey != null && BYTE_ARRAY_COMPARATOR.compare(this.lastProcessedKey, (byte[])smallestEntry.getFirst()) == 0) continue;
            this.lastProcessedKey = (byte[])smallestEntry.getFirst();
            if (BranchCommitReadingStore.isTombStone((byte[])smallestEntry.getSecond())) continue;
            this.keys.add((byte[])smallestEntry.getFirst());
            if (!this.preserveValue) {
                this.values.add(null);
                continue;
            }
            this.values.add((byte[])smallestEntry.getSecond());
            if (BranchCommitReadingStore.isActualValueOrTombStone((byte[])smallestEntry.getSecond())) continue;
            this.valueIndexesThatNeedDeduplication.add(this.values.size() - 1);
        }
        return;
    }

    private @Nullable Queue<Pair<byte[], byte[]>> getQueueWithSmallestEntry(boolean endOfScanReached) {
        Queue<Pair<byte[], byte[]>> queueWithSmallestEntry = null;
        for (Queue<Pair<byte[], byte[]>> queuedEntry : this.queuedEntries) {
            if (queuedEntry.isEmpty()) {
                if (endOfScanReached) continue;
                return null;
            }
            if (queueWithSmallestEntry != null && QUEUE_COMPARATOR.compare(queueWithSmallestEntry, queuedEntry) <= 0) continue;
            queueWithSmallestEntry = queuedEntry;
        }
        return queueWithSmallestEntry;
    }

    public void invokeCallback(IKeyValueCallback callback) {
        for (int i = 0; i < this.values.size(); ++i) {
            callback.callback(this.keys.get(i), this.values.get(i));
        }
    }

    public byte[] getValue(int index) {
        return this.values.get(index);
    }

    public void setValue(int index, byte[] value) {
        this.values.set(index, value);
    }

    public List<Integer> getValueIndexesThatNeedDeduplication() {
        return this.valueIndexesThatNeedDeduplication;
    }
}

