/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.mem;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.distribution.LocalLockProvider;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.ByteArrayComparator;
import org.conqat.engine.persistence.store.base.StoreBase;
import org.conqat.engine.persistence.store.capability.ISnapshotBackupCapability;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class InMemoryStore
extends StoreBase {
    private NavigableMap<byte[], byte[]> data = new TreeMap<byte[], byte[]>(ByteArrayComparator.INSTANCE);
    private NavigableMap<byte[], byte[]> snapshot;
    private final ILockProvider lockProvider = new LocalLockProvider();

    public InMemoryStore() {
    }

    InMemoryStore(InMemoryStore other) {
        this.data.putAll(other.data);
        this.snapshot = null;
    }

    @Override
    public synchronized byte[] get(byte @NonNull [] key) throws StorageException {
        InMemoryStore.throwIfKeyIsNull(key);
        byte[] value = (byte[])this.data.get(key);
        if (value == null) {
            return null;
        }
        return (byte[])value.clone();
    }

    @Override
    public synchronized void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        InMemoryStore.throwIfKeyIsNull(key);
        this.data.put((byte[])key.clone(), (byte[])value.clone());
    }

    @Override
    public synchronized void remove(byte @NonNull [] key) throws StorageException {
        InMemoryStore.throwIfKeyIsNull(key);
        this.data.remove(key);
    }

    @Override
    public synchronized void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) {
        this.doScan(beginKey, endKey, callback, true);
    }

    @Override
    public synchronized void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) {
        this.doScan(beginKey, endKey, callback, false);
    }

    private void doScan(byte[] beginKey, byte[] endKey, IKeyValueCallback callback, boolean includeValue) {
        if (this.data.isEmpty()) {
            return;
        }
        Map.Entry<byte[], byte[]> currentEntry = beginKey == null ? this.data.firstEntry() : this.data.ceilingEntry(beginKey);
        while (currentEntry != null && (endKey == null || ByteArrayComparator.INSTANCE.compare(currentEntry.getKey(), endKey) < 0)) {
            byte[] value = null;
            if (includeValue) {
                value = (byte[])currentEntry.getValue().clone();
            }
            callback.callback((byte[])currentEntry.getKey().clone(), value);
            currentEntry = this.data.higherEntry(currentEntry.getKey());
        }
    }

    public synchronized void clear() {
        this.data.clear();
    }

    public synchronized boolean isEmpty() {
        return this.data.isEmpty();
    }

    public synchronized String getUsageStatistics(boolean detailed) {
        if (!detailed) {
            return "entries: " + this.data.size();
        }
        long keyBytes = 0L;
        long valueBytes = 0L;
        for (Map.Entry entry : this.data.entrySet()) {
            keyBytes += (long)((byte[])entry.getKey()).length;
            valueBytes += (long)((byte[])entry.getValue()).length;
        }
        return "entries: " + this.data.size() + ", keys (byte): " + keyBytes + ", values (byte): " + valueBytes;
    }

    public synchronized void createSnapshot() {
        this.snapshot = new TreeMap<byte[], byte[]>((SortedMap<byte[], byte[]>)this.data);
    }

    public synchronized void restoreFromSnapshot() {
        CCSMAssert.isTrue((this.snapshot != null ? 1 : 0) != 0, (String)"Must create a snapshot before restoring!");
        this.data = new TreeMap<byte[], byte[]>((SortedMap<byte[], byte[]>)this.snapshot);
    }

    @Override
    public Lock obtainLock(String suffix) {
        return this.lockProvider.obtainLock(suffix);
    }

    void dumpSnapshotBackup(ISnapshotBackupCapability.ISnapshotConsumer snapshotConsumer) throws StorageException, IOException {
        for (Map.Entry entry : this.data.entrySet()) {
            snapshotConsumer.writeKeyValue((byte[])entry.getKey(), (byte[])entry.getValue());
        }
    }
}

