/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.transaction;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.ByteArrayComparator;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TransactionalStore
implements IStore {
    private static final int COMMIT_BATCH_SIZE = 10000;
    private static final byte[] DELETION_MARKER = new byte[]{1};
    private final IStore mainStore;
    private final IStore changeStore;
    private final IStore deletionStore;
    private int pendingWriteCount = 0;

    public TransactionalStore(IStore mainStore) {
        this(mainStore, new InMemoryStore(), new InMemoryStore());
    }

    public TransactionalStore(IStore mainStore, IFactory<IStore, StorageException> tempStoreCreator) throws StorageException {
        this(mainStore, (IStore)tempStoreCreator.create(), (IStore)tempStoreCreator.create());
    }

    private TransactionalStore(IStore mainStore, IStore changeStore, IStore deletionStore) {
        this.mainStore = mainStore;
        this.changeStore = changeStore;
        this.deletionStore = deletionStore;
    }

    @Override
    public byte[] get(byte @NonNull [] key) throws StorageException {
        byte[] value = this.changeStore.get(key);
        if (value != null) {
            return value;
        }
        if (this.deletionStore.get(key) != null) {
            return null;
        }
        return this.mainStore.get(key);
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        List<byte[]> result = this.mainStore.get(keys);
        List<byte[]> deleted = this.deletionStore.get(keys);
        for (int i = 0; i < deleted.size(); ++i) {
            if (deleted.get(i) == null) continue;
            result.set(i, null);
        }
        List<byte[]> localChanges = this.changeStore.get(keys);
        for (int i = 0; i < localChanges.size(); ++i) {
            if (localChanges.get(i) == null) continue;
            result.set(i, localChanges.get(i));
        }
        return result;
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        this.deletionStore.remove(key);
        this.changeStore.put(key, value);
        ++this.pendingWriteCount;
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        this.deletionStore.remove(keysValues.extractFirstList());
        this.changeStore.put(keysValues);
        this.pendingWriteCount += keysValues.size();
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        this.changeStore.remove(key);
        this.deletionStore.put(key, DELETION_MARKER);
        ++this.pendingWriteCount;
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        this.changeStore.remove(keys);
        PairList keysValues = new PairList();
        for (byte[] key : keys) {
            keysValues.add((Object)key, (Object)DELETION_MARKER);
        }
        this.deletionStore.put((PairList<byte[], byte[]>)keysValues);
        this.pendingWriteCount += keys.size();
    }

    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        this.remove(StorageUtils.listKeysStartingWith(prefix, (IStore)this));
    }

    @Override
    public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        TreeMap<byte[], byte[]> entries = new TreeMap<byte[], byte[]>(ByteArrayComparator.INSTANCE);
        this.mainStore.scan(beginKey, endKey, new AppendingStoreCallback(entries));
        this.deletionStore.scan(beginKey, endKey, new DeletingStoreCallback(entries));
        this.changeStore.scan(beginKey, endKey, new AppendingStoreCallback(entries));
        TransactionalStore.replayEntries(entries, callback);
    }

    private static void replayEntries(Map<byte[], byte[]> entries, IKeyValueCallback callback) {
        for (Map.Entry<byte[], byte[]> entry : entries.entrySet()) {
            callback.callback(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void scan(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        TreeMap<byte[], byte[]> entries = new TreeMap<byte[], byte[]>(ByteArrayComparator.INSTANCE);
        this.mainStore.scan(prefix, (IKeyValueCallback)new AppendingStoreCallback(entries));
        this.deletionStore.scan(prefix, (IKeyValueCallback)new DeletingStoreCallback(entries));
        this.changeStore.scan(prefix, (IKeyValueCallback)new AppendingStoreCallback(entries));
        TransactionalStore.replayEntries(entries, callback);
    }

    @Override
    public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        List entriesList = CollectionUtils.map(prefixes, prefix -> new TreeMap(ByteArrayComparator.INSTANCE));
        this.mainStore.scan(prefixes, CollectionUtils.map((Collection)entriesList, AppendingStoreCallback::new));
        this.deletionStore.scan(prefixes, CollectionUtils.map((Collection)entriesList, DeletingStoreCallback::new));
        this.changeStore.scan(prefixes, CollectionUtils.map((Collection)entriesList, AppendingStoreCallback::new));
        for (int i = 0; i < entriesList.size(); ++i) {
            TransactionalStore.replayEntries((Map)entriesList.get(i), callbacks.get(i));
        }
    }

    @Override
    public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        TreeMap<byte[], byte[]> entries = new TreeMap<byte[], byte[]>(ByteArrayComparator.INSTANCE);
        this.mainStore.scanKeys(beginKey, endKey, new AppendingStoreCallback(entries));
        this.deletionStore.scanKeys(beginKey, endKey, new DeletingStoreCallback(entries));
        this.changeStore.scanKeys(beginKey, endKey, new AppendingStoreCallback(entries));
        TransactionalStore.replayEntries(entries, callback);
    }

    @Override
    public void scanKeys(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        TreeMap<byte[], byte[]> entries = new TreeMap<byte[], byte[]>(ByteArrayComparator.INSTANCE);
        this.mainStore.scanKeys(prefix, (IKeyValueCallback)new AppendingStoreCallback(entries));
        this.deletionStore.scanKeys(prefix, (IKeyValueCallback)new DeletingStoreCallback(entries));
        this.changeStore.scanKeys(prefix, (IKeyValueCallback)new AppendingStoreCallback(entries));
        TransactionalStore.replayEntries(entries, callback);
    }

    @Override
    public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        List entriesList = CollectionUtils.map(prefixes, prefix -> new TreeMap(ByteArrayComparator.INSTANCE));
        this.mainStore.scanKeys(prefixes, CollectionUtils.map((Collection)entriesList, AppendingStoreCallback::new));
        this.deletionStore.scanKeys(prefixes, CollectionUtils.map((Collection)entriesList, DeletingStoreCallback::new));
        this.changeStore.scanKeys(prefixes, CollectionUtils.map((Collection)entriesList, AppendingStoreCallback::new));
        for (int i = 0; i < entriesList.size(); ++i) {
            TransactionalStore.replayEntries((Map)entriesList.get(i), callbacks.get(i));
        }
    }

    @Override
    public Lock obtainLock(String suffix) {
        return this.mainStore.obtainLock(suffix);
    }

    @Override
    public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
        return this.mainStore.getCapability(capability);
    }

    public void commit() throws StorageException {
        final PairList keysValues = new PairList();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(){

            @Override
            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                keysValues.add((Object)key, (Object)value);
                if (keysValues.size() >= 10000) {
                    TransactionalStore.this.mainStore.put((PairList<byte[], byte[]>)keysValues);
                    keysValues.clear();
                }
            }
        };
        this.changeStore.scan(new byte[0], (IKeyValueCallback)callback);
        callback.throwCaughtException();
        if (!keysValues.isEmpty()) {
            this.mainStore.put((PairList<byte[], byte[]>)keysValues);
        }
        StorageUtils.batchProcessKeys(this.deletionStore, 10000, (ConsumerWithException<List<byte[]>, StorageException>)((ConsumerWithException)this.mainStore::remove));
        this.rollback();
    }

    public void rollback() throws StorageException {
        StorageUtils.clearStore(this.changeStore);
        StorageUtils.clearStore(this.deletionStore);
        this.pendingWriteCount = 0;
    }

    public int getPendingWriteCount() {
        return this.pendingWriteCount;
    }

    @ThreadSafe
    private static final class AppendingStoreCallback
    extends TransactionCallbackBase {
        public AppendingStoreCallback(Map<byte[], byte[]> entries) {
            super(entries);
        }

        @Override
        public synchronized void callback(byte[] key, byte[] value) {
            this.entries.put(key, value);
        }
    }

    @ThreadSafe
    private static final class DeletingStoreCallback
    extends TransactionCallbackBase {
        public DeletingStoreCallback(Map<byte[], byte[]> entries) {
            super(entries);
        }

        @Override
        public synchronized void callback(byte[] key, byte[] value) {
            this.entries.remove(key);
        }
    }

    @ThreadSafe
    private static abstract class TransactionCallbackBase
    implements IKeyValueCallback {
        protected final Map<byte[], byte[]> entries;

        protected TransactionCallbackBase(Map<byte[], byte[]> entries) {
            this.entries = entries;
        }
    }
}

