/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressReport
implements Runnable {
    private final long period;
    private final Logger logger;
    private long count;
    private long currentFileNumber = -1L;
    private String currentFilename;
    private Iterator<String> it;
    private final Thread thread;
    private final String adjective;
    private boolean success = false;
    private final AtomicBoolean interrupted = new AtomicBoolean();

    public ProgressReport(String threadName, long period, Logger logger, String adjective) {
        this.interrupted.set(false);
        this.period = period;
        this.logger = logger;
        this.adjective = adjective;
        this.thread = new Thread(this);
        this.thread.setName(threadName);
        this.thread.setDaemon(true);
    }

    public ProgressReport(String threadName, long period, String adjective) {
        this(threadName, period, LoggerFactory.getLogger(ProgressReport.class), adjective);
    }

    public ProgressReport(String threadName, long period) {
        this(threadName, period, "analyzed");
    }

    @Override
    public void run() {
        this.log(this.count + " source " + ProgressReport.pluralizeFile(this.count) + " to be " + this.adjective);
        while (!this.interrupted.get() && !Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(this.period);
                this.log(this.currentFileNumber + "/" + this.count + " " + ProgressReport.pluralizeFile(this.currentFileNumber) + " " + this.adjective + ", current file: " + this.currentFilename);
            }
            catch (InterruptedException e) {
                this.interrupted.set(true);
                this.thread.interrupt();
                break;
            }
        }
        if (this.success) {
            this.log(this.count + "/" + this.count + " source " + ProgressReport.pluralizeFile(this.count) + " " + ProgressReport.pluralizeHas(this.count) + " been " + this.adjective);
        }
    }

    private static String pluralizeFile(long count) {
        if (count == 1L) {
            return "file";
        }
        return "files";
    }

    private static String pluralizeHas(long count) {
        if (count == 1L) {
            return "has";
        }
        return "have";
    }

    public synchronized void start(Iterable<String> filenames) {
        this.count = ProgressReport.size(filenames);
        this.it = filenames.iterator();
        this.nextFile();
        this.thread.start();
    }

    public synchronized void nextFile() {
        if (this.it.hasNext()) {
            ++this.currentFileNumber;
            this.currentFilename = this.it.next();
        }
    }

    public synchronized void stop() {
        this.interrupted.set(true);
        this.success = true;
        this.thread.interrupt();
        this.join();
    }

    public synchronized void cancel() {
        this.interrupted.set(true);
        this.thread.interrupt();
        this.join();
    }

    private void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String message2) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.info(message2);
            this.logger.notifyAll();
        }
    }

    private static long size(Iterable<String> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).count();
    }
}

