/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.CommonConstantsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.frontend.KotlinFileContextKt;
import org.sonarsource.kotlin.checks.UnpredictableHashSaltCheckKt;

@Rule(key="S2053")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/sonarsource/kotlin/checks/UnpredictableHashSaltCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/Set;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "matchedFun", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "byteArrayInitSizeTooSmall", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nUnpredictableHashSaltCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnpredictableHashSaltCheck.kt\norg/sonarsource/kotlin/checks/UnpredictableHashSaltCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class UnpredictableHashSaltCheck
extends CallAbstractCheck {
    @NotNull
    private final Set<FunMatcherImpl> functionsToVisit = UnpredictableHashSaltCheckKt.access$getMatcherSaltIndexMap$p().keySet();

    @NotNull
    public Set<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        KtExpression predictedSaltValue;
        KtExpression saltArg;
        Object object;
        BindingContext bindingContext2;
        block9: {
            block8: {
                Object object2;
                ResolvedCall<? extends CallableDescriptor> resolvedCall3;
                ResolvedValueArgument resolvedValueArgument;
                Intrinsics.checkNotNullParameter(callExpression, "callExpression");
                Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
                Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
                Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                Object v = UnpredictableHashSaltCheckKt.access$getMatcherSaltIndexMap$p().get(matchedFun);
                Intrinsics.checkNotNull(v);
                int saltArgIndex = ((Number)v).intValue();
                if (callExpression.getValueArguments().size() < 2) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)callExpression, "Add an unpredictable salt value to this hash.", null, null, 12, null);
                    return;
                }
                bindingContext2 = kotlinFileContext.getBindingContext();
                List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
                if (list2 == null || (resolvedValueArgument = CollectionsKt.getOrNull(list2, saltArgIndex)) == null || (resolvedCall3 = resolvedValueArgument.getArguments()) == null || (object = CollectionsKt.getOrNull(resolvedCall3, 0)) == null || (object2 = object.getArgumentExpression()) == null) {
                    return;
                }
                saltArg = object2;
                predictedSaltValue = ApiExtensionsKt.predictRuntimeValueExpression$default(saltArg, bindingContext2, null, 2, null);
                if (ApiExtensionsKt.isBytesInitializedFromString(predictedSaltValue, bindingContext2)) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)saltArg, "Make this salt unpredictable.", CollectionsKt.listOf(KotlinFileContextKt.secondaryOf(kotlinFileContext, predictedSaltValue, "Predictable salt value")), null, 8, null);
                    return;
                }
                resolvedCall3 = CallUtilKt.getResolvedCall(predictedSaltValue, bindingContext2);
                if (resolvedCall3 == null) break block8;
                Object it = object2 = resolvedCall3;
                boolean bl = false;
                Object object3 = object = FunMatcherKt.matches(it, CommonConstantsKt.getBYTE_ARRAY_CONSTRUCTOR()) ? object2 : null;
                if (object != null) break block9;
            }
            return;
        }
        Object saltInitializer = object;
        if (this.byteArrayInitSizeTooSmall((ResolvedCall<?>)saltInitializer, bindingContext2)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)saltArg, "Make this salt at least 16 bytes.", CollectionsKt.listOf(KotlinFileContextKt.secondaryOf$default(kotlinFileContext, predictedSaltValue, null, 2, null)), null, 8, null);
        }
        if (FunMatcherKt.matches(saltInitializer, CommonConstantsKt.getBYTE_ARRAY_CONSTRUCTOR_SIZE_ARG_ONLY()) && ApiExtensionsKt.isInitializedPredictably(saltArg, predictedSaltValue, bindingContext2)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)saltArg, "Make this salt unpredictable.", CollectionsKt.listOf(KotlinFileContextKt.secondaryOf(kotlinFileContext, predictedSaltValue, "Predictable salt value")), null, 8, null);
        }
    }

    private final boolean byteArrayInitSizeTooSmall(ResolvedCall<?> $this$byteArrayInitSizeTooSmall, BindingContext bindingContext2) {
        Object object = ApiExtensionsKt.simpleArgExpressionOrNull($this$byteArrayInitSizeTooSmall, 0);
        return (object != null && (object = ApiExtensionsKt.predictRuntimeIntValue((KtExpression)object, bindingContext2)) != null ? (Integer)object : 16) < 16;
    }
}

