/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.versioning;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.service.framework.impl.versioning.VersionRoutingHandler;
import com.teamscale.service.framework.versioning.VersionedMediaTypeUtils;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.jetbrains.annotations.VisibleForTesting;

@PreMatching
@Provider
public class VersionUriSupport
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Pattern VERSIONED_URI = Pattern.compile("api/v([0-9]+)[._]([0-9]+)(?:[._]([0-9]+|[Xx]))?/");
    private static final String ORIGINAL_ACCEPTED_MEDIA_TYPES_KEY = "original_accept_header";

    public void filter(ContainerRequestContext requestContext) {
        UriInfo uriInfo = requestContext.getUriInfo();
        String eventuallyVersionedPath = uriInfo.getPath(false);
        Optional<Pair<ETeamscaleVersion, String>> versionAndRewrittenPath = VersionUriSupport.parseUriVersion(eventuallyVersionedPath);
        if (versionAndRewrittenPath.isEmpty()) {
            return;
        }
        ETeamscaleVersion version = (ETeamscaleVersion)versionAndRewrittenPath.get().getFirst();
        String nonVersionedPath = uriInfo.getBaseUri().getPath() + (String)versionAndRewrittenPath.get().getSecond();
        UriBuilder newUri = UriBuilder.fromUri((URI)uriInfo.getRequestUri()).replacePath(nonVersionedPath);
        requestContext.setRequestUri(newUri.build(new Object[0]));
        requestContext.setProperty(ORIGINAL_ACCEPTED_MEDIA_TYPES_KEY, (Object)requestContext.getAcceptableMediaTypes());
        Set<MediaType> updatedMediaTypes = VersionUriSupport.getUpdatedMediaTypes(requestContext, version);
        requestContext.getHeaders().put((Object)"Accept", (Object)CollectionUtils.map(updatedMediaTypes, MediaType::toString));
    }

    private static Set<MediaType> getUpdatedMediaTypes(ContainerRequestContext requestContext, ETeamscaleVersion version) {
        Set<MediaType> acceptableMediaTypes = VersionUriSupport.getAcceptableMediaTypesWithoutWildcards(requestContext);
        Set versionedMediaTypes = VersionedMediaTypeUtils.convertToVersionedMediaTypes(acceptableMediaTypes, (ETeamscaleVersion)version);
        return Stream.concat(versionedMediaTypes.stream(), acceptableMediaTypes.stream().map(type -> {
            HashMap<String, String> parameters = new HashMap<String, String>(type.getParameters());
            parameters.put("q", "0");
            parameters.put("qs", "0");
            return new MediaType(type.getType(), type.getSubtype(), parameters);
        })).collect(Collectors.toSet());
    }

    private static Set<MediaType> getAcceptableMediaTypesWithoutWildcards(ContainerRequestContext requestContext) {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (MediaType acceptableMediaType : requestContext.getAcceptableMediaTypes()) {
            block4: {
                block3: {
                    if (acceptableMediaType.isWildcardType()) break block3;
                    if (!acceptableMediaType.isWildcardSubtype()) break block4;
                }
                result.addAll(VersionRoutingHandler.getAllVersionedProducedMediaTypes().stream().filter(arg_0 -> ((MediaType)acceptableMediaType).isCompatible(arg_0)).map(mt -> new MediaType(mt.getType(), mt.getSubtype(), acceptableMediaType.getParameters())).toList());
                continue;
            }
            result.add(acceptableMediaType);
        }
        return result;
    }

    @VisibleForTesting
    static Optional<Pair<ETeamscaleVersion, String>> parseUriVersion(String eventuallyVersionedPath) {
        Matcher matcher = VERSIONED_URI.matcher(eventuallyVersionedPath);
        if (!matcher.lookingAt()) {
            return Optional.empty();
        }
        int majorVersion = Integer.parseInt(matcher.group(1));
        int minorVersion = Integer.parseInt(matcher.group(2));
        String patchVersionString = matcher.group(3);
        int patchVersion = Integer.MAX_VALUE;
        if (patchVersionString != null && !patchVersionString.equalsIgnoreCase("x")) {
            patchVersion = Integer.parseInt(patchVersionString);
        }
        ETeamscaleVersion version = VersionUriSupport.getClosestMatchingTeamscaleVersion(majorVersion, minorVersion, patchVersion);
        String nonVersionedPath = matcher.replaceFirst("api/");
        return Optional.of(new Pair((Object)version, (Object)nonVersionedPath));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        List originalAcceptedMediaTypes = (List)requestContext.getProperty(ORIGINAL_ACCEPTED_MEDIA_TYPES_KEY);
        if (originalAcceptedMediaTypes == null) {
            return;
        }
        MediaType mediaType = responseContext.getMediaType();
        if (mediaType == null || originalAcceptedMediaTypes.contains(mediaType)) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)"Content-Type", (Object)VersionedMediaTypeUtils.convertToNonVersionedMediaType((MediaType)mediaType).toString());
    }

    @VisibleForTesting
    static ETeamscaleVersion getClosestMatchingTeamscaleVersion(int majorVersion, int minorVersion, int patchVersion) {
        ETeamscaleVersion bestMatch = ETeamscaleVersion.VERSION_1_0_0;
        for (ETeamscaleVersion version : ETeamscaleVersion.values()) {
            if (version.getMajor() > majorVersion || version.getMinor() > minorVersion || version.getPatch() > patchVersion) continue;
            bestMatch = version;
        }
        return bestMatch;
    }
}

