/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index;

import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.index.IStorageInfo;
import java.io.Serializable;
import java.util.OptionalLong;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.LastChangeTrackingValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Index(name="metric-threshold-configurations", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP})
public class MetricThresholdConfigurationIndex
implements IGlobalIndex,
IChangeTrackingIndex {
    private final LastChangeTrackingValueIndex<MetricThresholdConfiguration> delegate;
    public static final String INDEX_NAME = "metric-threshold-configurations";

    public MetricThresholdConfigurationIndex(IStore store) {
        this.delegate = new LastChangeTrackingValueIndex(store);
    }

    public MetricThresholdConfiguration getConfiguration(String thresholdConfigurationName) throws StorageException {
        return (MetricThresholdConfiguration)this.delegate.getValue(thresholdConfigurationName);
    }

    public static String createContentHash(IStorageInfo storageInfo) throws StorageException {
        return String.valueOf(((MetricThresholdConfigurationIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(MetricThresholdConfigurationIndex.class)).getLastChangeTimestamp().orElse(-1L));
    }

    public PairList<String, MetricThresholdConfiguration> getAllThresholdConfigurations() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public void setThresholdConfiguration(MetricThresholdConfiguration metricThresholdConfiguration) throws StorageException {
        this.delegate.setValue(metricThresholdConfiguration.getName(), (Serializable)metricThresholdConfiguration);
    }

    public void removeThresholdConfiguration(String metricThresholdConfigurationName) throws StorageException {
        this.delegate.removeValue(metricThresholdConfigurationName);
    }

    public OptionalLong getLastChangeTimestamp() throws StorageException {
        return this.delegate.getLastChangeTimestamp();
    }
}

