/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.crowd.client;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="restriction-type")
public sealed interface ICrowdSearchRestriction {

    @JsonTypeName(value="property-search-restriction")
    public record PropertyCrowdSearchRestriction<T>(@JsonProperty(value="property") Property<T> property, @JsonProperty(value="match-mode") EMatchMode matchMode, @JsonProperty(value="value") @Nullable T value) implements ICrowdSearchRestriction
    {
        public PropertyCrowdSearchRestriction(@JsonProperty(value="property") Property<T> property, @JsonProperty(value="match-mode") EMatchMode matchMode, @JsonProperty(value="value") @Nullable T value) {
            CCSMAssert.isNotNull(property, () -> String.format("Expected \"%s\" to be not null", "property"));
            CCSMAssert.isNotNull((Object)((Object)matchMode), () -> String.format("Expected \"%s\" to be not null", "matchMode"));
            CCSMAssert.isTrue((value == null == (matchMode == EMatchMode.NULL) ? 1 : 0) != 0, () -> String.format("Expected \"%s\" to be (not) null if match mode is not null", "value"));
            if (value != null) {
                CCSMAssert.isInstanceOf(value, property.type());
            }
        }

        public static enum EMatchMode {
            EXACTLY_MATCHES,
            STARTS_WITH,
            CONTAINS,
            LESS_THAN,
            GREATER_THAN,
            NULL;

        }

        public record Property<T>(@JsonProperty(value="name") String name, Class<T> type) {
            public Property {
                CCSMAssert.isNotNull((Object)name, () -> String.format("Expected \"%s\" to be not null", "name"));
                CCSMAssert.isNotNull(type, () -> String.format("Expected \"%s\" to be not null", "type"));
            }

            @JsonGetter(value="type")
            String getTypeName() {
                return this.type.getSimpleName();
            }
        }
    }
}

