/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.saml;

import com.teamscale.core.authenticate.saml.SamlAuthenticationOption;
import jakarta.ws.rs.BadRequestException;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.XMLParserException;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jspecify.annotations.NonNull;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.config.impl.JavaCryptoValidationInitializer;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.w3c.dom.Document;

public final class SamlUtils {
    private static boolean initialized = false;
    private static CertificateFactory x509CertificateFactory;

    public static synchronized void ensureInitialized() throws InitializationException {
        if (initialized) {
            return;
        }
        new JavaCryptoValidationInitializer().init();
        InitializationService.initialize();
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            x509CertificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new InitializationException("Server misconfigured! X.509 support not found! " + e.getMessage(), (Throwable)e);
        }
        initialized = true;
    }

    public static EntityDescriptor parseEntityDescriptor(String metadataXml) throws XMLParserException, UnmarshallingException, BadRequestException {
        XMLObject xmlObject = XMLObjectSupport.unmarshallFromReader((ParserPool)XMLObjectProviderRegistrySupport.getParserPool(), (Reader)new StringReader(metadataXml));
        if (!(xmlObject instanceof EntityDescriptor)) {
            throw new BadRequestException("Expected entity descriptor, but received " + String.valueOf(xmlObject.getClass()));
        }
        return (EntityDescriptor)xmlObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Credential extractCredential(String metadataXml) throws BadRequestException {
        EntityDescriptor entityDescriptor;
        try {
            entityDescriptor = SamlUtils.parseEntityDescriptor(metadataXml);
        }
        catch (XMLParserException | UnmarshallingException e) {
            throw new BadRequestException("Could not parse provided metadata XML: " + e.getMessage(), e);
        }
        X509Certificate x509Certificate = SamlUtils.extractX509Certificate(entityDescriptor);
        try {
            CertificateFactory certificateFactory = x509CertificateFactory;
            synchronized (certificateFactory) {
                java.security.cert.X509Certificate certificate = (java.security.cert.X509Certificate)x509CertificateFactory.generateCertificate(new ByteArrayInputStream(Base64Support.decode((String)x509Certificate.getValue())));
                return CredentialSupport.getSimpleCredential((java.security.cert.X509Certificate)certificate, null);
            }
        }
        catch (CertificateException | DecodingException e) {
            throw new BadRequestException("Could not parse the provided X.509 certificate: " + e.getMessage(), e);
        }
    }

    private static X509Certificate extractX509Certificate(EntityDescriptor entityDescriptor) throws BadRequestException {
        IDPSSODescriptor ssoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (ssoDescriptor == null && (ssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol")) == null) {
            throw new BadRequestException("No SSO descriptor (urn:oasis:names:tc:SAML:2.0:protocol) found in metadata.");
        }
        List keyDescriptors = ssoDescriptor.getKeyDescriptors();
        if (CollectionUtils.isNullOrEmpty((Collection)keyDescriptors)) {
            throw new BadRequestException("No key descriptors found in SSO descriptor of metadata.");
        }
        KeyInfo keyInfo = SamlUtils.findBestKeyInfo(keyDescriptors);
        List x509Datas = keyInfo.getX509Datas();
        if (CollectionUtils.isNullOrEmpty((Collection)x509Datas)) {
            throw new BadRequestException("No X509 data found in metadata.");
        }
        List x509Certificates = ((X509Data)x509Datas.get(0)).getX509Certificates();
        if (CollectionUtils.isNullOrEmpty((Collection)x509Certificates) || x509Certificates.get(0) == null) {
            throw new BadRequestException("No X509 certificates found in metadata.");
        }
        return (X509Certificate)x509Certificates.get(0);
    }

    private static KeyInfo findBestKeyInfo(List<KeyDescriptor> keyDescriptors) throws BadRequestException {
        KeyInfo keyInfo;
        boolean foundMatchingDescriptor = false;
        for (KeyDescriptor keyDescriptor : keyDescriptors) {
            if (keyDescriptor.getUse() != UsageType.SIGNING) continue;
            foundMatchingDescriptor = true;
            keyInfo = keyDescriptor.getKeyInfo();
            if (keyInfo == null) continue;
            return keyInfo;
        }
        for (KeyDescriptor keyDescriptor : keyDescriptors) {
            if (keyDescriptor.getUse() != null && keyDescriptor.getUse() != UsageType.UNSPECIFIED) continue;
            foundMatchingDescriptor = true;
            keyInfo = keyDescriptor.getKeyInfo();
            if (keyInfo == null) continue;
            return keyInfo;
        }
        if (foundMatchingDescriptor) {
            throw new BadRequestException("No key info found in SSO descriptor of metadata.");
        }
        throw new BadRequestException("No key descriptor that is usable for signing found in SSO descriptor of metadata.");
    }

    public static String extractEntityId(String metadataXml) throws BadRequestException {
        String entityId;
        try {
            entityId = SamlUtils.parseEntityDescriptor(metadataXml).getEntityID();
        }
        catch (XMLParserException | UnmarshallingException e) {
            throw new BadRequestException("Could not parse metadata XML: " + e.getMessage(), e);
        }
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            throw new BadRequestException("Entity id missing from metadata XML");
        }
        return entityId;
    }

    public static String createServiceProviderConfiguration(SamlAuthenticationOption option, String serviceLocationUrl, List<String> hints) throws BadRequestException {
        Optional<byte[]> certificate;
        try {
            SamlUtils.ensureInitialized();
        }
        catch (InitializationException e) {
            throw new BadRequestException((Throwable)e);
        }
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        EntityDescriptor entityDescriptor = (EntityDescriptor)SamlUtils.createSamlObject(EntityDescriptor.DEFAULT_ELEMENT_NAME, builderFactory);
        entityDescriptor.setEntityID(option.serviceProviderId);
        SPSSODescriptor ssoDescriptor = SamlUtils.setupSpssoDescriptor(builderFactory);
        entityDescriptor.getRoleDescriptors().add(ssoDescriptor);
        SamlUtils.appendIdFormat(option, builderFactory, ssoDescriptor);
        if (serviceLocationUrl != null) {
            SamlUtils.appendAssertionConsumerService(builderFactory, ssoDescriptor, serviceLocationUrl);
        }
        if ((certificate = option.getCertificate()).isEmpty()) {
            hints.add("Certificate not yet configured. Save settings once to enable encrypted SAML assertions.");
        } else {
            SamlUtils.appendKey(builderFactory, ssoDescriptor, UsageType.ENCRYPTION, certificate.get());
        }
        try {
            return SamlUtils.buildMetaXMLString(entityDescriptor);
        }
        catch (ParserConfigurationException | TransformerException | MarshallingException e) {
            throw new BadRequestException(e);
        }
    }

    private static String buildMetaXMLString(EntityDescriptor entityDescriptor) throws ParserConfigurationException, MarshallingException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)entityDescriptor).marshall((XMLObject)entityDescriptor, document);
        return XMLUtils.prettyPrint((Document)document);
    }

    private static @NonNull SPSSODescriptor setupSpssoDescriptor(XMLObjectBuilderFactory builderFactory) {
        SPSSODescriptor ssoDescriptor = (SPSSODescriptor)SamlUtils.createSamlObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME, builderFactory);
        ssoDescriptor.setWantAssertionsSigned(Boolean.valueOf(true));
        ssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(false));
        ssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        return ssoDescriptor;
    }

    private static void appendIdFormat(SamlAuthenticationOption option, XMLObjectBuilderFactory builderFactory, SPSSODescriptor ssoDescriptor) {
        NameIDFormat nameIdFormat = (NameIDFormat)SamlUtils.createSamlObject(NameIDFormat.DEFAULT_ELEMENT_NAME, builderFactory);
        if (StringUtils.isEmpty((CharSequence)option.idAttribute)) {
            nameIdFormat.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        } else {
            nameIdFormat.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        }
        ssoDescriptor.getNameIDFormats().add(nameIdFormat);
    }

    private static void appendAssertionConsumerService(XMLObjectBuilderFactory builderFactory, SPSSODescriptor ssoDescriptor, String serviceLocation) {
        AssertionConsumerService assertionConsumerService = (AssertionConsumerService)SamlUtils.createSamlObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME, builderFactory);
        assertionConsumerService.setIndex(Integer.valueOf(0));
        assertionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        assertionConsumerService.setLocation(serviceLocation);
        assertionConsumerService.setIsDefault(Boolean.valueOf(true));
        ssoDescriptor.getAssertionConsumerServices().add(assertionConsumerService);
    }

    private static void appendKey(XMLObjectBuilderFactory builderFactory, SPSSODescriptor ssoDescriptor, UsageType type, byte[] certificateAsBytes) {
        X509Certificate certificate = (X509Certificate)SamlUtils.createSamlObject(X509Certificate.DEFAULT_ELEMENT_NAME, builderFactory);
        certificate.setValue(Base64.getEncoder().encodeToString(certificateAsBytes));
        X509Data keyData = (X509Data)SamlUtils.createSamlObject(X509Data.DEFAULT_ELEMENT_NAME, builderFactory);
        keyData.getX509Certificates().add(certificate);
        KeyInfo keyInfo = (KeyInfo)SamlUtils.createSamlObject(KeyInfo.DEFAULT_ELEMENT_NAME, builderFactory);
        keyInfo.getX509Datas().add(keyData);
        KeyDescriptor keyDescriptor = (KeyDescriptor)SamlUtils.createSamlObject(KeyDescriptor.DEFAULT_ELEMENT_NAME, builderFactory);
        keyDescriptor.setUse(type);
        keyDescriptor.setKeyInfo(keyInfo);
        ssoDescriptor.getKeyDescriptors().add(keyDescriptor);
    }

    public static byte[] createSelfSignedX509Certificate(KeyPair keyPair) {
        ZonedDateTime now = DateTimeUtils.zonedNow();
        Instant validityBegin = now.minusDays(1L).toInstant();
        Instant validityEnd = now.plusYears(3L).toInstant();
        X509V1CertificateGenerator certificateGenerator = new X509V1CertificateGenerator();
        X500Principal dnName = new X500Principal("CN=CQSE GmbH");
        certificateGenerator.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certificateGenerator.setSubjectDN(dnName);
        certificateGenerator.setIssuerDN(dnName);
        certificateGenerator.setNotBefore(Date.from(validityBegin));
        certificateGenerator.setNotAfter(Date.from(validityEnd));
        certificateGenerator.setPublicKey(keyPair.getPublic());
        certificateGenerator.setSignatureAlgorithm("SHA256WithRSAEncryption");
        try {
            return certificateGenerator.generate(keyPair.getPrivate()).getEncoded();
        }
        catch (GeneralSecurityException ex) {
            return null;
        }
    }

    public static java.security.cert.X509Certificate parseCertificateFromBytes(byte[] rawCertificateData) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(rawCertificateData));
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Unable to parse X509 certificate from byte[]", e);
        }
    }

    private static <T> T createSamlObject(QName qName, XMLObjectBuilderFactory builderFactory) {
        return (T)builderFactory.getBuilder(qName).buildObject(qName);
    }

    public static Decrypter getDecrypter(SamlAuthenticationOption option) throws DecryptionException {
        try {
            BasicCredential credential = CredentialSupport.getSimpleCredential((PublicKey)option.getPublicKey().get(), (PrivateKey)option.getPrivateKey().get());
            StaticKeyInfoCredentialResolver keyInfoCredentialResolver = new StaticKeyInfoCredentialResolver((Credential)credential);
            Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyInfoCredentialResolver, (EncryptedKeyResolver)new ChainingEncryptedKeyResolver(List.of(new InlineEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleKeyInfoReferenceEncryptedKeyResolver())));
            decrypter.setRootInNewDocument(true);
            return decrypter;
        }
        catch (GeneralSecurityException e) {
            throw new DecryptionException("Decryption failed", (Exception)e);
        }
    }

    private SamlUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

