/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings.metrics;

import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.findings.metrics.FindingsCountForAllCategoriesMetric;
import com.teamscale.core.findings.metrics.FindingsCountMetric;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.values.EMetricValueType;
import java.util.ArrayList;
import java.util.List;

public class FindingsCountForSingleCategoryMetric
extends FindingsCountMetric {
    private final String categoryName;
    private final String findingsCountForAllCategoriesId;
    private final boolean createHiddenMetric;

    public FindingsCountForSingleCategoryMetric(FindingsCountForAllCategoriesMetric allCategoriesReferenceMetric, String categoryName, boolean createHiddenMetric) {
        super(FindingsCountForSingleCategoryMetric.generateIdFromName(allCategoriesReferenceMetric.referenceMetric.getId(), categoryName), "Number of Findings in " + categoryName + FindingsCountForSingleCategoryMetric.getColorString(allCategoriesReferenceMetric.color, " (", ")", true), allCategoriesReferenceMetric.referenceMetric.getDescription() + " in the quality indicator " + categoryName, allCategoriesReferenceMetric.color);
        this.findingsCountForAllCategoriesId = allCategoriesReferenceMetric.id;
        this.categoryName = categoryName;
        this.createHiddenMetric = createHiddenMetric;
    }

    @Override
    public void registerInSchema(MetricSchemaProxy schema) throws ProjectConfigurationException {
        IMetricSource metricSource = schema.createCounterSetValueSizeMetricSource(this.findingsCountForAllCategoriesId, new String[]{this.categoryName});
        schema.addMetric(this.id, metricSource, this.getName(), this.getDescription(), EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, (EMetricProperty[])FindingsCountForSingleCategoryMetric.createProperties(this.createHiddenMetric).toArray(EMetricProperty[]::new));
    }

    private static List<EMetricProperty> createProperties(boolean hidden) {
        ArrayList<EMetricProperty> properties = new ArrayList<EMetricProperty>();
        properties.add(EMetricProperty.ARCHITECTURE_RELEVANT);
        if (hidden) {
            properties.add(EMetricProperty.HIDDEN);
        }
        return properties;
    }

    public String getCategoryName() {
        return this.categoryName;
    }
}

