/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.license;

import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.license.License;
import com.teamscale.core.license.LicenseException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

public class LicenseManager {
    private static final String TS_LICENSE_ENV_VARIABLE_NAME = "TS_LICENSE";
    private static final String TS_LICENSE_FILE_ENV_VARIABLE_NAME = "TS_LICENSE_FILE";
    public static final String LICENSE_FILE_NAME = "teamscale.license";
    private static LicenseManager instance;
    private License license = null;
    private LicenseSource source = null;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> lookupDetails = new ArrayList<String>();

    private LicenseManager() {
        this.reloadLicense();
    }

    public synchronized void reloadLicense() {
        this.errors.clear();
        this.license = null;
        this.source = this.locateLicense().orElse(null);
        if (this.source == null) {
            this.errors.add("No license found:");
            this.errors.addAll(this.lookupDetails);
            return;
        }
        try (Reader reader = (Reader)this.source.reader.get();){
            License license = this.readLicense(reader);
            if (!license.verifySignature()) {
                this.errors.add("Invalid signature in license file " + this.source.location);
                return;
            }
            license.loadEnvironmentVariableOverwrites();
            if (license.getExpired()) {
                this.errors.add("License file " + this.source.location + " only valid until " + String.valueOf(license.getValidTo()));
            } else {
                this.license = license;
            }
        }
        catch (LicenseException | IOException e) {
            this.errors.add("Error during license check of license file '" + this.source.location + "': " + e.getMessage());
        }
    }

    private License readLicense(Reader reader) throws IOException, LicenseException {
        return License.read(reader, this.errors);
    }

    private Optional<LicenseSource> locateLicense() {
        List<Supplier> sources = Arrays.asList(LicenseSource.environment(this.lookupDetails), LicenseSource.environmentFile(this.lookupDetails), LicenseSource.file(() -> TeamscaleInstallationUtils.locateConfigFile((String)LICENSE_FILE_NAME), this.lookupDetails), LicenseSource.resource(() -> Resource.asOptional(LicenseManager.class, (String)LICENSE_FILE_NAME)), LicenseSource.directory(FileSystemUtils.getUserHomeDir().getAbsolutePath(), this.lookupDetails));
        return sources.stream().map(Supplier::get).filter(Objects::nonNull).findFirst();
    }

    public static synchronized LicenseManager getInstance() {
        if (instance == null) {
            instance = new LicenseManager();
        }
        return instance;
    }

    public synchronized License getLicense() {
        return this.license;
    }

    public List<String> getErrors() {
        return CollectionUtils.asUnmodifiable(this.errors);
    }

    public synchronized String getLicenseLocation() {
        if (this.source != null) {
            return this.source.location;
        }
        return null;
    }

    public synchronized boolean isCppcheckPremiumLicensed() {
        return this.license != null && this.license.isCppcheckPremium();
    }

    private record LicenseSource(String location, SupplierWithException<Reader, IOException> reader) {
        private static Supplier<LicenseSource> environment(List<String> lookupDetails) {
            return () -> {
                String license = System.getenv(LicenseManager.TS_LICENSE_ENV_VARIABLE_NAME);
                if (StringUtils.isEmpty((String)license)) {
                    lookupDetails.add("No license set in environment variable TS_LICENSE");
                    return null;
                }
                return new LicenseSource("$TS_LICENSE", (SupplierWithException<Reader, IOException>)((SupplierWithException)() -> new StringReader(System.getenv(LicenseManager.TS_LICENSE_ENV_VARIABLE_NAME))));
            };
        }

        private static Supplier<LicenseSource> environmentFile(List<String> lookupDetails) {
            return () -> {
                String licenseFile = System.getenv(LicenseManager.TS_LICENSE_FILE_ENV_VARIABLE_NAME);
                if (StringUtils.isEmpty((String)licenseFile)) {
                    lookupDetails.add("No license file set in environment variable TS_LICENSE_FILE");
                    return null;
                }
                return LicenseSource.file(new File(System.getenv(LicenseManager.TS_LICENSE_FILE_ENV_VARIABLE_NAME)), lookupDetails);
            };
        }

        private static Supplier<LicenseSource> directory(String directory, List<String> lookupDetails) {
            return () -> {
                if (StringUtils.isEmpty((String)directory)) {
                    return null;
                }
                return LicenseSource.file(new File(directory, LicenseManager.LICENSE_FILE_NAME), lookupDetails);
            };
        }

        private static Supplier<LicenseSource> file(Supplier<Optional<File>> license, List<String> lookupDetails) {
            return () -> ((Optional)license.get()).map(licenseFile -> LicenseSource.file(licenseFile, lookupDetails)).orElse(null);
        }

        private static Supplier<LicenseSource> resource(Supplier<Optional<Resource>> resource) {
            return () -> ((Optional)resource.get()).map(license -> new LicenseSource(license.getUrl().toString(), (SupplierWithException<Reader, IOException>)((SupplierWithException)() -> new InputStreamReader(license.getAsStream(), StandardCharsets.UTF_8)))).orElse(null);
        }

        private static LicenseSource file(File license, List<String> lookupDetails) {
            if (!license.exists()) {
                lookupDetails.add("License file " + String.valueOf(license) + " does not exist");
                return null;
            }
            if (!license.canRead()) {
                lookupDetails.add("Cannot read " + String.valueOf(license) + ". Please verify that file can be accessed by " + System.getProperty("user.name"));
                return null;
            }
            return new LicenseSource(license.getAbsolutePath(), (SupplierWithException<Reader, IOException>)((SupplierWithException)() -> new FileReader(license, StandardCharsets.UTF_8)));
        }
    }
}

