/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class MetricDirectorySchema
implements Serializable {
    public static final MetricDirectorySchema EMPTY = new MetricDirectorySchema(Collections.emptyList());
    private static final String ENTRIES_PROPERTY = "entries";
    private static final long serialVersionUID = 1L;
    public static final int NOT_AVAILABLE_VALUE_POSITION = -1;
    @JsonProperty(value="entries")
    private final List<MetricDirectorySchemaEntry> entries;
    private transient Map<String, Integer> metricNameToIndex;
    private transient MetricDirectorySchema hiddenSchema;
    private transient MetricDirectorySchema publicSchema;

    @JsonCreator
    public MetricDirectorySchema(@JsonProperty(value="entries") Collection<MetricDirectorySchemaEntry> entries) {
        this.entries = new ArrayList<MetricDirectorySchemaEntry>(entries);
    }

    public MetricDirectorySchemaEntry getEntry(int index) {
        return this.entries.get(index);
    }

    public MetricDirectorySchemaEntry getEntry(String name) {
        int valuePosition = this.getValuePosition(name);
        if (valuePosition == -1) {
            return null;
        }
        return this.getEntry(valuePosition);
    }

    public UnmodifiableList<MetricDirectorySchemaEntry> getAllEntries() {
        return CollectionUtils.asUnmodifiable(this.entries);
    }

    public synchronized MetricDirectorySchema extractPublicSchema() {
        if (this.publicSchema == null) {
            this.publicSchema = this.extractSchema(Predicate.not(MetricDirectorySchemaEntry::isHidden));
        }
        return this.publicSchema;
    }

    public synchronized MetricDirectorySchema extractHiddenSchema() {
        if (this.hiddenSchema == null) {
            this.hiddenSchema = this.extractSchema(MetricDirectorySchemaEntry::isHidden);
        }
        return this.hiddenSchema;
    }

    private MetricDirectorySchema extractSchema(Predicate<MetricDirectorySchemaEntry> entryFilter) {
        List<MetricDirectorySchemaEntry> matchingEntries = this.entries.stream().filter(entryFilter).toList();
        if (matchingEntries.size() == this.entries.size()) {
            return this;
        }
        return new MetricDirectorySchema(matchingEntries);
    }

    public int size() {
        return this.entries.size();
    }

    public synchronized int getValuePosition(String name) {
        Integer result;
        if (this.metricNameToIndex == null) {
            this.metricNameToIndex = IntStream.range(0, this.entries.size()).boxed().collect(Collectors.toUnmodifiableMap(i -> this.entries.get((int)i).getName(), Function.identity()));
        }
        if ((result = this.metricNameToIndex.get(name)) == null) {
            return -1;
        }
        return result;
    }

    public String toString() {
        return this.entries.toString();
    }
}

