/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.permissions.DefaultGlobalRoles;
import com.teamscale.core.permissions.DefaultProjectRoles;
import com.teamscale.core.permissions.roles.EBasicRole;
import com.teamscale.core.permissions.roles.GlobalRole;
import com.teamscale.core.permissions.roles.IRole;
import com.teamscale.core.permissions.roles.ProjectRole;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class RoleSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, EBasicRole> BASIC_ROLES = new HashMap<String, EBasicRole>();
    private final Map<String, ProjectRole> projectRolesByName = new HashMap<String, ProjectRole>();
    private final Map<String, GlobalRole> globalRolesByName = new HashMap<String, GlobalRole>();

    public EBasicRole getBasicRole(String roleName) {
        return BASIC_ROLES.get(roleName);
    }

    private static void validateRole(IRole<?> role) throws StorageException {
        if (role == null) {
            throw new StorageException("Invalid role null");
        }
        if (role.getReadableName() == null) {
            throw new StorageException("Role is missing a readable name.");
        }
        if (role.getDescription() == null) {
            throw new StorageException("Role is missing a description.");
        }
        Set<?> permissions = role.getPermissions();
        if (permissions == null || permissions.isEmpty()) {
            throw new StorageException("Role is missing permissions.");
        }
    }

    public GlobalRole getGlobalRole(String roleName) {
        return RoleSchema.getRole(this.globalRolesByName, roleName, DefaultGlobalRoles.FIXED_GLOBAL_ROLES);
    }

    public Set<GlobalRole> getGlobalRoles() {
        return RoleSchema.getRoles(this.globalRolesByName, DefaultGlobalRoles.FIXED_GLOBAL_ROLES);
    }

    public void setGlobalRole(String oldRoleName, GlobalRole globalRole) throws StorageException {
        RoleSchema.setRole(this.globalRolesByName, oldRoleName, globalRole, "Instance Admin");
    }

    public void deleteGlobalRole(String roleName) throws StorageException {
        RoleSchema.deleteRole(this.globalRolesByName, roleName, "Instance Admin");
    }

    public ProjectRole getProjectRole(String roleName) {
        return RoleSchema.getRole(this.projectRolesByName, roleName, DefaultProjectRoles.FIXED_PROJECT_ROLES);
    }

    public Set<ProjectRole> getProjectRoles() {
        return RoleSchema.getRoles(this.projectRolesByName, DefaultProjectRoles.FIXED_PROJECT_ROLES);
    }

    public void setProjectRole(String oldRoleName, ProjectRole projectRole) throws StorageException {
        RoleSchema.setRole(this.projectRolesByName, oldRoleName, projectRole, "Project Administrator");
    }

    public void deleteProjectRole(String roleName) throws StorageException {
        RoleSchema.deleteRole(this.projectRolesByName, roleName, "Project Administrator");
    }

    private static void deleteRole(Map<String, ? extends IRole<?>> rolesByName, String roleName, String disallowedRoleName) throws StorageException {
        RoleSchema.ensureRoleNameAllowed(roleName, disallowedRoleName);
        RoleSchema.ensureRoleExists(rolesByName, roleName);
        rolesByName.remove(roleName);
    }

    private static <V extends IRole<?>> V getRole(Map<String, V> rolesByName, String roleName, Collection<V> fixedRoles) {
        Optional<IRole> optionalFixedRole = fixedRoles.stream().filter(fixedRole -> fixedRole.getReadableName().equals(roleName)).findFirst();
        return (V)optionalFixedRole.orElseGet(() -> (IRole)rolesByName.get(roleName));
    }

    private static <V extends IRole<?>> Set<V> getRoles(Map<String, V> rolesByName, Collection<V> fixedRoles) {
        Collection<V> dynamicRoles = rolesByName.values();
        HashSet result = HashSet.newHashSet(dynamicRoles.size() + 1);
        result.addAll(dynamicRoles);
        result.addAll(fixedRoles);
        return result;
    }

    private static <V extends IRole<?>> void setRole(Map<String, V> rolesByName, String oldRoleName, V role, String disallowedRoleName) throws StorageException {
        RoleSchema.validateRole(role);
        if (RoleSchema.isRoleRename(oldRoleName, role)) {
            RoleSchema.ensureRoleExists(rolesByName, oldRoleName);
            rolesByName.remove(oldRoleName);
        }
        String roleName = role.getReadableName();
        RoleSchema.ensureRoleNameAllowed(roleName, disallowedRoleName);
        rolesByName.put(roleName, role);
    }

    private static void ensureRoleNameAllowed(String roleName, String disallowedRoleName) throws StorageException {
        if (disallowedRoleName.equals(roleName)) {
            throw new StorageException("Can't change role: " + disallowedRoleName);
        }
    }

    private static boolean isRoleRename(String oldRoleName, IRole<?> role) {
        return !StringUtils.isEmpty((String)oldRoleName) && !oldRoleName.equals(role.getReadableName());
    }

    private static void ensureRoleExists(Map<String, ? extends IRole<?>> rolesByName, String roleName) throws StorageException {
        if (!rolesByName.containsKey(roleName)) {
            throw new StorageException("Role doesn't exist: " + roleName);
        }
    }

    static {
        Arrays.stream(EBasicRole.values()).forEach(role -> BASIC_ROLES.put(role.getReadableName(), (EBasicRole)role));
    }
}

