/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.collections.DurableCollectionIndex;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.date.DurationUtils;

@Index(name="worker", options={EStorageOption.COMPRESSED}, valueClasses={WorkerClusterStatus.class, ProjectSchedulingFilter.class})
public class WorkerIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "worker";
    public static final Duration SINGLE_NODE_MAX_AGE_MILLIS = DurationUtils.ONE_HOUR;
    public static final Duration ONE_OF_MANY_NODES_MAX_AGE = DurationUtils.ONE_MINUTE;
    private final DurableCollectionIndex<?> delegate;

    public WorkerIndex(IStore store) {
        super(store);
        this.delegate = new DurableCollectionIndex(store);
    }

    public WorkerClusterStatusAccess getWorkerClusterStatusAccess() {
        return new WorkerClusterStatusAccess();
    }

    public SchedulingFilterAccess getSchedulingFilterAccess() {
        return new SchedulingFilterAccess(this.store);
    }

    public DurableIdGenerator createJobAndDeltaIdGenerator() {
        return this.delegate.createDistributedDurableIdGenerator("jobs-and-deltas");
    }

    public class WorkerClusterStatusAccess {
        private static final String PREFIX = "status:";

        public void persistClusterStatus(WorkerClusterStatus clusterStatus) throws StorageException {
            WorkerIndex.this.store.putWithString(PREFIX + clusterStatus.getProcessId(), StorageUtils.serialize((Serializable)clusterStatus));
        }

        public List<WorkerClusterStatus> listAll() throws StorageException {
            ResultListCallback callback = new ResultListCallback();
            WorkerIndex.this.store.scan(PREFIX, (IKeyValueCallback)callback);
            List statuses = callback.getResultOrThrowException();
            Duration maxAge = statuses.size() == 1 ? SINGLE_NODE_MAX_AGE_MILLIS : ONE_OF_MANY_NODES_MAX_AGE;
            ArrayList keysToDelete = new ArrayList();
            statuses.removeIf(status -> DurationUtils.elapsed((Duration)maxAge, (long)status.getLastRefreshed()) && keysToDelete.add(PREFIX + status.getProcessId()));
            return statuses;
        }
    }

    public static class SchedulingFilterAccess {
        private static final String KEY = "scheduler.filter";
        private final ConvenientStore store;

        private SchedulingFilterAccess(ConvenientStore store) {
            this.store = store;
        }

        public ProjectSchedulingFilter get() throws StorageException {
            byte[] value = this.store.getWithString(KEY);
            if (value == null) {
                return new ProjectSchedulingFilter();
            }
            return (ProjectSchedulingFilter)StorageUtils.deserialize((byte[])value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T modify(Function<? super ProjectSchedulingFilter, ? extends T> modifier) throws StorageException {
            Objects.requireNonNull(modifier, "modifier");
            Lock lock = this.store.obtainLock(KEY);
            lock.lock();
            try {
                ProjectSchedulingFilter filter = this.get();
                T result = modifier.apply(filter);
                this.store.putWithString(KEY, StorageUtils.serialize((Serializable)filter));
                T t = result;
                return t;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

