/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IWorkspaceMapping;
import com.microsoft.tfs.core.clients.build.IWorkspaceTemplate;
import com.microsoft.tfs.core.clients.build.flags.WorkspaceMappingDepth;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.WorkspaceMapping;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.WorkspaceTemplate2010;
import com.microsoft.tfs.core.clients.build.soapextensions.WorkspaceMappingType;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.util.ArrayList;
import java.util.Calendar;
import ms.tfs.build.buildservice._04._WorkspaceMapping;
import ms.tfs.build.buildservice._04._WorkspaceTemplate;

public class WorkspaceTemplate
extends WebServiceObjectWrapper
implements IWorkspaceTemplate {
    public WorkspaceTemplate() {
        this(new _WorkspaceTemplate());
        _WorkspaceTemplate _o = this.getWebServiceObject();
        _o.setMappings(new _WorkspaceMapping[0]);
        _o.setLastModifiedDate(DotNETDate.MIN_CALENDAR);
    }

    public WorkspaceTemplate(_WorkspaceTemplate webServiceObject) {
        super(webServiceObject);
    }

    public WorkspaceTemplate(WorkspaceTemplate2010 template) {
        this();
        _WorkspaceTemplate _o = this.getWebServiceObject();
        _o.setDefinitionUri(template.getDefinitionURI());
        _o.setLastModifiedBy(template.getLastModifiedBy());
        _o.setLastModifiedDate(template.getLastModifiedDate());
        Object[] mappings = TFS2010Helper.convert(template.getInternalMappings());
        _o.setMappings((_WorkspaceMapping[])WrapperUtils.unwrap(_WorkspaceMapping.class, mappings));
    }

    public _WorkspaceTemplate getWebServiceObject() {
        return (_WorkspaceTemplate)this.webServiceObject;
    }

    public String getDefinitionURI() {
        return this.getWebServiceObject().getDefinitionUri();
    }

    public void setDefinitionURI(String value) {
        this.getWebServiceObject().setDefinitionUri(value);
    }

    public WorkspaceMapping[] getInternalMappings() {
        Object[] mappings = this.getWebServiceObject().getMappings();
        if (mappings == null) {
            return new WorkspaceMapping[0];
        }
        return (WorkspaceMapping[])WrapperUtils.wrap(WorkspaceMapping.class, mappings);
    }

    public void setInternalMappings(WorkspaceMapping[] value) {
        this.getWebServiceObject().setMappings((_WorkspaceMapping[])WrapperUtils.unwrap(_WorkspaceMapping.class, value));
    }

    @Override
    public String getLastModifiedBy() {
        return this.getWebServiceObject().getLastModifiedBy();
    }

    @Override
    public Calendar getLastModifiedDate() {
        return this.getWebServiceObject().getLastModifiedDate();
    }

    @Override
    public IWorkspaceMapping[] getMappings() {
        return this.getInternalMappings();
    }

    @Override
    public IWorkspaceMapping addMapping() {
        WorkspaceMapping mapping = new WorkspaceMapping();
        _WorkspaceMapping[] _mappings = this.getWebServiceObject().getMappings();
        _WorkspaceMapping[] _newMappings = new _WorkspaceMapping[_mappings.length + 1];
        for (int i = 0; i < _mappings.length; ++i) {
            _newMappings[i] = _mappings[i];
        }
        _newMappings[_newMappings.length - 1] = mapping.getWebServiceObject();
        this.getWebServiceObject().setMappings(_newMappings);
        return mapping;
    }

    @Override
    public IWorkspaceMapping addMapping(String serverItem, String localItem, WorkspaceMappingType type) {
        return this.addMapping(serverItem, localItem, type, WorkspaceMappingDepth.FULL);
    }

    @Override
    public IWorkspaceMapping addMapping(String serverItem, String localItem, WorkspaceMappingType type, WorkspaceMappingDepth depth) {
        IWorkspaceMapping mapping = this.addMapping();
        mapping.setServerItem(serverItem);
        mapping.setLocalItem(type.equals(WorkspaceMappingType.CLOAK) ? null : localItem);
        mapping.setMappingType(type);
        mapping.setDepth(depth);
        return mapping;
    }

    @Override
    public IWorkspaceMapping cloak(String serverItem) {
        return this.addMapping(serverItem, null, WorkspaceMappingType.CLOAK);
    }

    @Override
    public IWorkspaceMapping map(String serverItem, String localItem) {
        return this.addMapping(serverItem, localItem, WorkspaceMappingType.MAP);
    }

    @Override
    public boolean removeMapping(IWorkspaceMapping mapping) {
        _WorkspaceMapping _mappingToRemove = ((WorkspaceMapping)mapping).getWebServiceObject();
        ArrayList<_WorkspaceMapping> list = new ArrayList<_WorkspaceMapping>();
        boolean removed = false;
        for (_WorkspaceMapping _mapping : this.getWebServiceObject().getMappings()) {
            if (!_mapping.equals(_mappingToRemove)) {
                list.add(_mapping);
                continue;
            }
            removed = true;
        }
        if (removed) {
            this.getWebServiceObject().setMappings(list.toArray(new _WorkspaceMapping[list.size()]));
        }
        return removed;
    }

    @Override
    public void clearMappings() {
        this.getWebServiceObject().setMappings(new _WorkspaceMapping[0]);
    }

    @Override
    public boolean removeMapping(String serverItem) {
        ArrayList<_WorkspaceMapping> list = new ArrayList<_WorkspaceMapping>();
        boolean removed = false;
        for (_WorkspaceMapping _mapping : this.getWebServiceObject().getMappings()) {
            if (ServerPath.equals(_mapping.getServerItem(), serverItem)) continue;
            list.add(_mapping);
            removed = true;
        }
        if (removed) {
            this.getWebServiceObject().setMappings(list.toArray(new _WorkspaceMapping[list.size()]));
        }
        return removed;
    }

    @Override
    public void copyFrom(IWorkspaceTemplate workspaceTemplate) {
        Check.notNull(workspaceTemplate, "workspaceTemplate");
        WorkspaceTemplate source = (WorkspaceTemplate)workspaceTemplate;
        this.getWebServiceObject().setDefinitionUri(source.getDefinitionURI());
        if (source.getInternalMappings() != null) {
            this.getWebServiceObject().setMappings((_WorkspaceMapping[])WrapperUtils.unwrap(_WorkspaceMapping.class, source.getInternalMappings()));
        } else {
            this.getWebServiceObject().setMappings(new _WorkspaceMapping[0]);
        }
        this.getWebServiceObject().setLastModifiedBy(source.getLastModifiedBy());
        this.getWebServiceObject().setLastModifiedDate(source.getLastModifiedDate());
    }
}

