/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.groupsecurity;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.authorization.Identity;
import com.microsoft.tfs.core.clients.authorization.IdentityType;
import com.microsoft.tfs.core.clients.authorization.QueryMembership;
import com.microsoft.tfs.core.clients.authorization.SearchFactor;
import com.microsoft.tfs.core.clients.commonstructure.CommonStructureClient;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityHelper;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.core.exceptions.mappers.GroupSecurityExceptionMapper;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import ms.tfs.services.groupsecurity._03._GroupSecurityServiceSoap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupSecurityClient {
    private static final Log log = LogFactory.getLog(GroupSecurityClient.class);
    private final TFSTeamProjectCollection connection;
    private final _GroupSecurityServiceSoap webService;

    public GroupSecurityClient(TFSTeamProjectCollection connection, _GroupSecurityServiceSoap webService) {
        Check.notNull(connection, "connection");
        Check.notNull(webService, "webService");
        this.connection = connection;
        this.webService = webService;
    }

    public Identity readIdentity(SearchFactor factor, String factorValue, QueryMembership queryMembership) {
        try {
            return new Identity(this.webService.readIdentity(factor.getWebServiceObject(), factorValue, queryMembership.getWebServiceObject()));
        }
        catch (ProxyException e) {
            throw GroupSecurityExceptionMapper.map(e);
        }
    }

    public TeamFoundationIdentity convert(Identity identity) {
        if (identity == null) {
            return null;
        }
        IdentityDescriptor descriptor = IdentityHelper.createDescriptorFromSID(identity.getSID());
        IdentityDescriptor[] members = null;
        if (identity.getMembers() != null) {
            members = new IdentityDescriptor[identity.getMembers().length];
            for (int i = 0; i < identity.getMembers().length; ++i) {
                members[i] = IdentityHelper.createDescriptorFromSID(identity.getMembers()[i]);
            }
        }
        IdentityDescriptor[] memberOf = null;
        if (identity.getMemberOf() != null) {
            memberOf = new IdentityDescriptor[identity.getMemberOf().length];
            for (int i = 0; i < identity.getMemberOf().length; ++i) {
                memberOf[i] = IdentityHelper.createDescriptorFromSID(identity.getMemberOf()[i]);
            }
        }
        TeamFoundationIdentity result = new TeamFoundationIdentity(descriptor, identity.getDisplayName(), !identity.isDeleted(), members, memberOf);
        if (identity.getType() == IdentityType.APPLICATION_GROUP || identity.getType() == IdentityType.WINDOWS_GROUP) {
            result.setAttribute("SchemaClassName", "Group");
        } else {
            result.setAttribute("SchemaClassName", "User");
        }
        result.setAttribute("Description", identity.getDescription());
        result.setAttribute("Domain", identity.getDomain());
        if (identity.getType() == IdentityType.APPLICATION_GROUP) {
            result.setAttribute("Account", identity.getDisplayName());
            if (identity.getDomain() == null || identity.getDomain().length() == 0) {
                result.setAttribute("GlobalScope", "GlobalScope");
            } else {
                String projectName = this.getProjectName(identity.getDomain());
                result.setAttribute("ScopeName", projectName);
                result.setDisplayName("[" + projectName + "]\\" + identity.getDisplayName());
            }
        } else {
            result.setAttribute("Account", identity.getAccountName());
        }
        result.setAttribute("Disambiguation", identity.getDomain() + "\\" + identity.getAccountName());
        result.setAttribute("DN", identity.getDistinguishedName());
        result.setAttribute("Mail", identity.getMailAddress());
        result.setAttribute("SecurityGroup", "SecurityGroup");
        result.setAttribute("SpecialType", identity.getSpecialType().toString());
        return result;
    }

    private String getProjectName(String scopeId) {
        String projectName = scopeId;
        CommonStructureClient commonStructureClient = this.connection.getCommonStructureClient();
        if (commonStructureClient != null) {
            try {
                ProjectInfo pi = commonStructureClient.getProject(scopeId);
                projectName = pi == null ? "" : pi.getName();
            }
            catch (Exception e) {
                log.info((Object)MessageFormat.format("Error resolving scopeID {0} to project name via common structure service, returning scopeId as name", scopeId), (Throwable)e);
            }
        }
        return projectName;
    }
}

