/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.LocalPendingChangeFlags;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.InvalidPendingChangeTableException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.WebServiceLayerLocalWorkspaces;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryReader;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryWriter;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ServerItemMapper;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTable;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalPendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumParentsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumSubTreeOptions;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumeratedSparseTreeNode;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.SparseTree;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.SparseTreeAdditionalData;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class LocalPendingChangesTable
extends LocalMetadataTable {
    private static final short MAGIC = 29733;
    private static final byte[] EMPTY_HASH = GUID.EMPTY.getGUIDBytes();
    private static final byte[] ZERO_LENGTH_ARRAY_BYTES = new byte[0];
    private static final byte SCHEMA_VERSION_1 = 1;
    private static final byte SCHEMA_VERSION_2 = 2;
    private GUID baseSignature;
    private GUID clientSignature;
    private boolean hasRenames;
    private SparseTree<LocalPendingChange> pendingChangesTarget;
    private SparseTree<LocalPendingChange> pendingChangesCommitted;
    private SparseTree<LocalPendingChange> pendingChangesCandidateTarget;

    public LocalPendingChangesTable(String fileName, LocalPendingChangesTable cachedLoadSource) throws Exception {
        super(fileName, cachedLoadSource);
    }

    @Override
    protected void initialize() {
        this.hasRenames = false;
        this.pendingChangesTarget = new SparseTree('/', (Comparator<String>)String.CASE_INSENSITIVE_ORDER);
        this.pendingChangesCommitted = new SparseTree('/', (Comparator<String>)String.CASE_INSENSITIVE_ORDER);
        this.pendingChangesCandidateTarget = new SparseTree('/', (Comparator<String>)String.CASE_INSENSITIVE_ORDER);
        this.baseSignature = WebServiceLayerLocalWorkspaces.INITIAL_PENDING_CHANGES_SIGNATURE;
        this.clientSignature = WebServiceLayerLocalWorkspaces.INITIAL_PENDING_CHANGES_SIGNATURE;
    }

    @Override
    protected void load(InputStream is) throws InvalidPendingChangeTableException, IOException {
        block8: {
            BinaryReader br = new BinaryReader(is, "UTF-16LE");
            try {
                short magic = br.readInt16();
                if (29733 != magic) {
                    throw new InvalidPendingChangeTableException();
                }
                byte schemaVersion = br.readByte();
                if (schemaVersion == 1 || schemaVersion == 2) {
                    this.loadFromVersion(br, schemaVersion);
                    break block8;
                }
                throw new InvalidPendingChangeTableException();
            }
            catch (Exception e) {
                if (e instanceof InvalidPendingChangeTableException) {
                    throw (InvalidPendingChangeTableException)e;
                }
                throw new InvalidPendingChangeTableException(e);
            }
            finally {
                br.close();
            }
        }
    }

    private void loadFromVersion(BinaryReader br, byte schemaVersion) throws InvalidPendingChangeTableException, IOException {
        byte[] clientSignatureBytes = br.readBytes(16);
        this.baseSignature = this.clientSignature = new GUID(clientSignatureBytes);
        int pendingChangeCount = br.readInt32();
        while (!br.isEOF()) {
            LocalPendingChange pc = new LocalPendingChange();
            pc.setTargetServerItem(br.readString());
            pc.setCommittedServerItem(br.readString());
            if (0 == pc.getCommittedServerItem().length()) {
                pc.setCommittedServerItem(null);
            }
            pc.setBranchFromItem(br.readString());
            if (0 == pc.getBranchFromItem().length()) {
                pc.setBranchFromItem(null);
            }
            pc.setVersion(br.readInt32());
            pc.setBranchFromVersion(br.readInt32());
            pc.setChangeType(ChangeType.fromIntFlags(br.readUInt32()));
            pc.setItemType(ItemType.fromByteValue(br.readByte()));
            pc.setEncoding(br.readInt32());
            pc.setLockStatus(br.readByte());
            pc.setItemID(br.readInt32());
            pc.setCreationDate(DotNETDate.fromBinary(br.readInt64()));
            pc.setDeletionID(br.readInt32());
            if (ItemType.FILE == pc.getItemType()) {
                pc.setHashValue(br.readBytes(16));
                if (Arrays.equals(pc.getHashValue(), EMPTY_HASH)) {
                    pc.setHashValue(ZERO_LENGTH_ARRAY_BYTES);
                }
            }
            if (schemaVersion != 1) {
                pc.setFlags(new LocalPendingChangeFlags(br.readByte()));
            }
            if (!pc.isCandidate()) {
                this.pendingChangesTarget.add(pc.getTargetServerItem(), pc, true);
                String committedItem = pc.getCommittedServerItem();
                if (committedItem != null && committedItem.length() > 0 && pc.isCommitted()) {
                    this.pendingChangesCommitted.add(committedItem, pc, true);
                }
                if (!pc.isRename()) continue;
                this.hasRenames = true;
                continue;
            }
            this.pendingChangesCandidateTarget.add(pc.getTargetServerItem(), pc, true);
        }
        if (this.pendingChangesTarget.getCount() != pendingChangeCount) {
            throw new InvalidPendingChangeTableException();
        }
    }

    @Override
    protected boolean cachedLoad(LocalMetadataTable source) {
        if (source instanceof LocalPendingChangesTable) {
            LocalPendingChangesTable pcCached = (LocalPendingChangesTable)source;
            this.clientSignature = pcCached.clientSignature;
            this.baseSignature = pcCached.clientSignature;
            this.hasRenames = pcCached.hasRenames;
            this.pendingChangesCommitted = pcCached.pendingChangesCommitted;
            this.pendingChangesTarget = pcCached.pendingChangesTarget;
            this.pendingChangesCandidateTarget = pcCached.pendingChangesCandidateTarget;
            source.setEligibleForCachedLoad(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean save(OutputStream os) throws IOException {
        BinaryWriter bw = new BinaryWriter(os, "UTF-16LE");
        try {
            bw.write((short)29733);
            this.writeToVersion1(bw);
        }
        finally {
            bw.close();
        }
        return true;
    }

    private void writeToVersion1(BinaryWriter bw) throws IOException {
        bw.write((byte)2);
        this.updateClientSignatureIfNecessary();
        bw.write(this.clientSignature.getGUIDBytes());
        bw.write(this.pendingChangesTarget.getCount());
        this.pendingChangesTarget.EnumSubTree("$/", new SaveCallback(), EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE, null, bw);
        this.pendingChangesCandidateTarget.EnumSubTree("$/", new SaveCallback(), EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE, null, bw);
    }

    public boolean hasSubItemOfLocalVersion(WorkspaceLocalItem lvEntry) {
        String targetServerItem = lvEntry.isCommitted() ? this.getTargetServerItemForCommittedServerItem(lvEntry.getServerItem()) : lvEntry.getServerItem();
        return this.hasSubItemOfTargetServerItem(targetServerItem);
    }

    public boolean hasSubItemOfTargetServerItem(String targetServerItem) {
        EnumSubTreeOptions options = EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT.combine(EnumSubTreeOptions.ENUMERATE_SPARSE_NODES);
        return this.pendingChangesTarget.EnumSubTree(targetServerItem, new HasSubItemCallback(), options, 0, null, null);
    }

    public LocalPendingChange getByTargetServerItem(String targetServerItem) {
        Check.notNullOrEmpty(targetServerItem, "targetServerItem");
        return this.pendingChangesTarget.get(targetServerItem);
    }

    public LocalPendingChange getByCommittedServerItem(String committedServerItem) {
        Check.notNullOrEmpty(committedServerItem, "committedServerItem");
        return this.pendingChangesCommitted.get(committedServerItem);
    }

    public LocalPendingChange getByLocalVersion(WorkspaceLocalItem lvEntry) {
        Check.notNull(lvEntry, "lvEntry");
        if (lvEntry.isCommitted()) {
            return this.getByCommittedServerItem(lvEntry.getServerItem());
        }
        return this.getByTargetServerItem(lvEntry.getServerItem());
    }

    public String getCommittedServerItemForTargetServerItem(String targetServerItem) {
        if (this.hasRenames) {
            LocalPendingChange rename = this.getFirstRenameForTargetItem(targetServerItem);
            if (rename == null) {
                return targetServerItem;
            }
            return rename.getCommittedServerItem() + targetServerItem.substring(rename.getTargetServerItem().length());
        }
        return targetServerItem;
    }

    public String getTargetServerItemForCommittedServerItem(String committedServerItem) {
        if (this.hasRenames) {
            LocalPendingChange rename = this.getFirstRenameForCommitedItem(committedServerItem);
            if (rename == null) {
                return committedServerItem;
            }
            return rename.getTargetServerItem() + committedServerItem.substring(rename.getCommittedServerItem().length());
        }
        return committedServerItem;
    }

    public String getTargetServerItemForLocalVersion(WorkspaceLocalItem lvEntry) {
        if (lvEntry.isCommitted()) {
            return this.getTargetServerItemForCommittedServerItem(lvEntry.getServerItem());
        }
        return lvEntry.getServerItem();
    }

    private LocalPendingChange getFirstRenameForCommitedItem(String committedServerItem) {
        GetFirstRenameState state = new GetFirstRenameState();
        this.pendingChangesCommitted.EnumParents(committedServerItem, new GetFirstRenameCallback(), EnumParentsOptions.NONE, null, state);
        return state.renamedParent;
    }

    private LocalPendingChange getFirstRenameForTargetItem(String targetServerItem) {
        GetFirstRenameState state = new GetFirstRenameState();
        this.pendingChangesTarget.EnumParents(targetServerItem, new GetFirstRenameCallback(), EnumParentsOptions.NONE, null, state);
        return state.renamedParent;
    }

    public ChangeType getRecursiveChangeTypeForLocalVersion(WorkspaceLocalItem lvEntry) {
        Check.notNull(lvEntry, "lvEntry");
        String targetServerItem = lvEntry.isCommitted() ? this.getTargetServerItemForCommittedServerItem(lvEntry.getServerItem()) : lvEntry.getServerItem();
        return this.getRecursiveChangeTypeForTargetServerItem(targetServerItem);
    }

    public ChangeType getRecursiveChangeTypeForTargetServerItem(String targetServerItem) {
        Check.notNullOrEmpty(targetServerItem, "targetServerItem");
        ChangeType inheritedChangeType = this.getInheritedChangeTypeForTargetServerItem(targetServerItem);
        LocalPendingChange pcEntry = this.getByTargetServerItem(targetServerItem);
        if (null == pcEntry) {
            return inheritedChangeType;
        }
        if (ChangeType.NONE == inheritedChangeType) {
            return pcEntry.getChangeType();
        }
        return pcEntry.getChangeType().combine(inheritedChangeType);
    }

    public ChangeType getInheritedChangeTypeForTargetServerItem(String targetServerItem) {
        Check.notNullOrEmpty(targetServerItem, "targetServerItem");
        ChangeType changeType = ChangeType.NONE;
        Iterable<LocalPendingChange> pcEntries = this.pendingChangesTarget.EnumParentsReferencedObjects(targetServerItem, EnumParentsOptions.NONE);
        for (LocalPendingChange pcEntry : pcEntries) {
            if (pcEntry.getChangeType().equals(ChangeType.NONE)) continue;
            changeType = changeType.combine(pcEntry.getChangeType().retain(ChangeType.RENAME_OR_DELETE));
        }
        return changeType;
    }

    public Iterable<LocalPendingChange> queryParentsOfTargetServerItem(String targetServerItem) {
        return this.pendingChangesTarget.EnumParentsReferencedObjects(targetServerItem, EnumParentsOptions.NONE);
    }

    public LocalPendingChange[] queryByTargetServerItem(String targetServerItem, RecursionType recursion, String pattern) {
        Check.notNullOrEmpty(targetServerItem, "targetServerItem");
        QueryState qpcState = new QueryState();
        qpcState.matchingItems = new ArrayList<LocalPendingChange>();
        qpcState.pattern = pattern;
        EnumSubTreeOptions options = EnumSubTreeOptions.NONE;
        if (pattern == null) {
            options = EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT;
        }
        this.pendingChangesTarget.EnumSubTree(targetServerItem, new QueryCallback(), options, LocalPendingChangesTable.depthFromRecursionType(recursion), null, qpcState);
        return qpcState.matchingItems.toArray(new LocalPendingChange[qpcState.matchingItems.size()]);
    }

    public Iterable<LocalPendingChange> queryByCommittedServerItem(String committedServerItem, RecursionType recursion, String pattern) {
        Check.notNullOrEmpty(committedServerItem, "committedServerItem");
        QueryState qpcState = new QueryState();
        qpcState.matchingItems = new ArrayList<LocalPendingChange>();
        qpcState.pattern = pattern;
        EnumSubTreeOptions options = EnumSubTreeOptions.NONE;
        if (pattern == null) {
            options = EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT;
        }
        this.pendingChangesCommitted.EnumSubTree(committedServerItem, new QueryCallback(), options, LocalPendingChangesTable.depthFromRecursionType(recursion), null, qpcState);
        return qpcState.matchingItems;
    }

    private static int depthFromRecursionType(RecursionType recursion) {
        if (recursion == RecursionType.NONE) {
            return 0;
        }
        if (recursion == RecursionType.ONE_LEVEL) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public void pendChange(LocalPendingChange change) {
        Check.notNull(change, "change");
        this.setDirty(true);
        this.pendingChangesTarget.set(change.getTargetServerItem(), change);
        String committed = change.getCommittedServerItem();
        if (committed != null && committed.length() > 0 && change.isCommitted()) {
            this.pendingChangesCommitted.set(committed, change);
        }
        if (change.isRename()) {
            this.hasRenames = true;
        }
    }

    public void remove(LocalPendingChange change) {
        Check.notNull(change, "change");
        this.setDirty(true);
        this.pendingChangesTarget.remove(change.getTargetServerItem(), false);
        String committed = change.getCommittedServerItem();
        if (committed != null && committed.length() > 0) {
            this.pendingChangesCommitted.remove(committed, false);
        }
    }

    public boolean removeByTargetServerItem(String targetServerItem) {
        Check.notNullOrEmpty(targetServerItem, "targetServerItem");
        LocalPendingChange pcEntry = this.pendingChangesTarget.get(targetServerItem);
        if (pcEntry != null) {
            this.setDirty(true);
            this.pendingChangesTarget.remove(pcEntry.getTargetServerItem(), false);
            String committed = pcEntry.getCommittedServerItem();
            if (committed != null && committed.length() > 0) {
                this.pendingChangesCommitted.remove(committed, false);
            }
            return true;
        }
        return false;
    }

    public void replacePendingChanges(PendingChange[] newPendingChanges) {
        this.setDirty(true);
        this.pendingChangesCommitted.clear();
        this.pendingChangesTarget.clear();
        this.hasRenames = false;
        for (PendingChange newPc : newPendingChanges) {
            this.pendChange(LocalPendingChange.fromPendingChange(newPc));
        }
    }

    public void replacePendingChanges(SparseTree<LocalPendingChange> pendingChangesTarget) {
        this.setDirty(true);
        this.pendingChangesTarget = pendingChangesTarget;
        this.pendingChangesCommitted.clear();
        this.hasRenames = false;
        pendingChangesTarget.EnumSubTree(null, new ReplaceCallback());
    }

    public Iterable<LocalPendingChange> queryCandidatesByTargetServerItem(String targetServerItem, RecursionType recursion, String pattern) {
        Check.notNullOrEmpty(targetServerItem, "targetServerItem");
        QueryState qpcState = new QueryState();
        qpcState.matchingItems = new ArrayList<LocalPendingChange>();
        qpcState.pattern = pattern;
        EnumSubTreeOptions options = EnumSubTreeOptions.NONE;
        if (pattern == null) {
            options = EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT;
        }
        this.pendingChangesCandidateTarget.EnumSubTree(targetServerItem, new QueryCallback(), options, LocalPendingChangesTable.depthFromRecursionType(recursion), null, qpcState);
        return qpcState.matchingItems;
    }

    public void addCandidate(LocalPendingChange pendingChange) {
        Check.notNull(pendingChange, "pendingChange");
        Check.isTrue(pendingChange.isCandidate(), "cannot call add with non-candidate pending change");
        if (pendingChange.isDelete()) {
            for (EnumeratedSparseTreeNode<LocalPendingChange> pc : this.pendingChangesCandidateTarget.EnumParents(pendingChange.getTargetServerItem(), EnumParentsOptions.NONE)) {
                if (!((LocalPendingChange)pc.referencedObject).getChangeType().contains(ChangeType.DELETE)) continue;
                return;
            }
            if (pendingChange.getItemType() == ItemType.FOLDER) {
                this.pendingChangesCandidateTarget.remove(pendingChange.getTargetServerItem(), true);
            }
        }
        this.pendingChangesCandidateTarget.add(pendingChange.getTargetServerItem(), pendingChange, true);
        this.setDirty(true);
    }

    public boolean removeCandidateByTargetServerItem(String targetServerItem) {
        return this.removeCandidateByTargetServerItem(targetServerItem, false);
    }

    public boolean removeCandidateByTargetServerItem(String targetServerItem, boolean recursive) {
        Check.notNullOrEmpty(targetServerItem, "targetServerItem");
        if (this.pendingChangesCandidateTarget.remove(targetServerItem, recursive)) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public LocalPendingChange getCandidateByTargetServerItem(String targetServerItem) {
        Check.notNullOrEmpty(targetServerItem, "targetServerItem");
        return this.pendingChangesCandidateTarget.get(targetServerItem);
    }

    public List<String> getKnownServerItems() {
        ArrayList<String> knownServerItems = new ArrayList<String>();
        for (LocalPendingChange pcEntry : this.pendingChangesTarget.EnumSubTreeReferencedObjects("$/", EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE)) {
            if (!StringUtil.isNullOrEmpty(pcEntry.getBranchFromItem())) {
                knownServerItems.add(pcEntry.getBranchFromItem());
            }
            if (StringUtil.isNullOrEmpty(pcEntry.getCommittedServerItem())) continue;
            knownServerItems.add(pcEntry.getCommittedServerItem());
        }
        for (LocalPendingChange pcEntry : this.pendingChangesCandidateTarget.EnumSubTreeReferencedObjects("$/", EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE)) {
            if (!StringUtil.isNullOrEmpty(pcEntry.getBranchFromItem())) {
                knownServerItems.add(pcEntry.getBranchFromItem());
            }
            if (StringUtil.isNullOrEmpty(pcEntry.getCommittedServerItem())) continue;
            knownServerItems.add(pcEntry.getCommittedServerItem());
        }
        return knownServerItems;
    }

    public void renameTeamProjects(ServerItemMapper serverItemMapper) {
        LocalPendingChange renamedEntry;
        this.setDirty(true);
        this.clientSignature = GUID.newGUID();
        this.pendingChangesCommitted.clear();
        ArrayList<LocalPendingChange> pcEntries = new ArrayList<LocalPendingChange>(this.pendingChangesTarget.getCount());
        for (LocalPendingChange pcEntry : this.pendingChangesTarget.EnumSubTreeReferencedObjects("$/", EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE)) {
            renamedEntry = pcEntry.clone();
            renamedEntry.setTargetServerItem(serverItemMapper.map(renamedEntry.getTargetServerItem()));
            if (!StringUtil.isNullOrEmpty(renamedEntry.getBranchFromItem())) {
                renamedEntry.setBranchFromItem(serverItemMapper.map(renamedEntry.getBranchFromItem()));
            }
            if (!StringUtil.isNullOrEmpty(renamedEntry.getCommittedServerItem())) {
                renamedEntry.setCommittedServerItem(serverItemMapper.map(renamedEntry.getCommittedServerItem()));
                if (renamedEntry.isCommitted()) {
                    this.pendingChangesCommitted.add(renamedEntry.getCommittedServerItem(), renamedEntry);
                }
            }
            pcEntries.add(renamedEntry);
        }
        this.pendingChangesTarget.clear();
        for (LocalPendingChange pcEntry : pcEntries) {
            this.pendingChangesTarget.add(pcEntry.getTargetServerItem(), pcEntry);
        }
        pcEntries = new ArrayList(this.pendingChangesCandidateTarget.getCount());
        for (LocalPendingChange pcEntry : this.pendingChangesCandidateTarget.EnumSubTreeReferencedObjects("$/", EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE)) {
            renamedEntry = pcEntry.clone();
            renamedEntry.setTargetServerItem(serverItemMapper.map(renamedEntry.getTargetServerItem()));
            if (!StringUtil.isNullOrEmpty(renamedEntry.getBranchFromItem())) {
                renamedEntry.setBranchFromItem(serverItemMapper.map(renamedEntry.getBranchFromItem()));
            }
            if (!StringUtil.isNullOrEmpty(renamedEntry.getCommittedServerItem())) {
                renamedEntry.setCommittedServerItem(serverItemMapper.map(renamedEntry.getCommittedServerItem()));
            }
            pcEntries.add(renamedEntry);
        }
        this.pendingChangesCandidateTarget.clear();
        for (LocalPendingChange pcEntry : pcEntries) {
            this.pendingChangesCandidateTarget.add(pcEntry.getTargetServerItem(), pcEntry);
        }
    }

    public boolean hasRenames() {
        return this.hasRenames;
    }

    public int getCount() {
        return this.pendingChangesTarget.getCount();
    }

    public GUID getClientSignature() {
        this.updateClientSignatureIfNecessary();
        return this.clientSignature;
    }

    public void setClientSignature(GUID value) {
        if (!value.equals(this.clientSignature)) {
            this.setDirty(true);
        }
        this.clientSignature = value;
    }

    private void updateClientSignatureIfNecessary() {
        if (this.isDirty() && this.baseSignature.equals(this.clientSignature)) {
            this.clientSignature = this.pendingChangesTarget.getCount() == 0 ? WebServiceLayerLocalWorkspaces.INITIAL_PENDING_CHANGES_SIGNATURE : GUID.newGUID();
        }
    }

    class SaveCallback
    implements SparseTree.EnumNodeCallback<LocalPendingChange> {
        SaveCallback() {
        }

        @Override
        public boolean invoke(String token, LocalPendingChange pc, SparseTreeAdditionalData additionalData, Object param) {
            BinaryWriter bw = (BinaryWriter)param;
            try {
                bw.write(pc.getTargetServerItem());
                bw.write(pc.getCommittedServerItem() == null ? "" : pc.getCommittedServerItem());
                bw.write(pc.getBranchFromItem() == null ? "" : pc.getBranchFromItem());
                bw.write(pc.getVersion());
                bw.write(pc.getBranchFromVersion());
                bw.write(pc.getChangeType().toIntFlags());
                bw.write(pc.getItemType().getValue());
                bw.write(pc.getEncoding());
                bw.write(pc.getLockStatus());
                bw.write(pc.getItemID());
                bw.write(DotNETDate.toBinary(pc.getCreationDate()));
                bw.write(pc.getDeletionID());
                if (ItemType.FILE == pc.getItemType()) {
                    if (null == pc.getHashValue() || pc.getHashValue().length != 16) {
                        bw.write(EMPTY_HASH);
                    } else {
                        bw.write(pc.getHashValue());
                    }
                }
                bw.write((byte)pc.getFlags().toIntFlags());
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
            return false;
        }
    }

    class ReplaceCallback
    implements SparseTree.EnumNodeCallback<LocalPendingChange> {
        ReplaceCallback() {
        }

        @Override
        public boolean invoke(String token, LocalPendingChange pcEntry, SparseTreeAdditionalData additionalData, Object param) {
            LocalPendingChangesTable.this.pendChange(pcEntry);
            return false;
        }
    }

    private class QueryCallback
    implements SparseTree.EnumNodeCallback<LocalPendingChange> {
        private QueryCallback() {
        }

        @Override
        public boolean invoke(String token, LocalPendingChange pcEntry, SparseTreeAdditionalData additionalData, Object param) {
            QueryState state = (QueryState)param;
            if (null == state.pattern || ItemPath.matchesWildcardFile(ServerPath.getFileName(token), state.pattern)) {
                state.matchingItems.add(pcEntry);
            }
            return false;
        }
    }

    private class QueryState {
        public List<LocalPendingChange> matchingItems;
        public String pattern;

        private QueryState() {
        }
    }

    private class GetFirstRenameCallback
    implements SparseTree.EnumNodeCallback<LocalPendingChange> {
        private GetFirstRenameCallback() {
        }

        @Override
        public boolean invoke(String token, LocalPendingChange pc, SparseTreeAdditionalData additionalData, Object param) {
            GetFirstRenameState state = (GetFirstRenameState)param;
            if (pc.isRename()) {
                state.renamedParent = pc;
                return true;
            }
            return false;
        }
    }

    private class GetFirstRenameState {
        public LocalPendingChange renamedParent;

        private GetFirstRenameState() {
        }
    }

    class HasSubItemCallback
    implements SparseTree.EnumNodeCallback<LocalPendingChange> {
        HasSubItemCallback() {
        }

        @Override
        public boolean invoke(String token, LocalPendingChange referencedObject, SparseTreeAdditionalData additionalData, Object param) {
            return true;
        }
    }
}

