/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.clients.framework.internal.ServiceInterfaceIdentifiers;
import com.microsoft.tfs.core.clients.workitem.GroupDataProvider;
import com.microsoft.tfs.core.clients.workitem.UserDisplayMode;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.WorkItemServerVersion;
import com.microsoft.tfs.core.clients.workitem.events.WorkItemEventEngine;
import com.microsoft.tfs.core.clients.workitem.exceptions.DeniedOrNotExistException;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinitionCollection;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.RegisteredLinkTypeCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.WorkItemLinkTypeCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadataChangeListener;
import com.microsoft.tfs.core.clients.workitem.internal.project.ProjectCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.NullQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.QueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.update.DestroyWorkItemTypeUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.internal.update.DestroyWorkItemUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.link.RegisteredLinkTypeCollection;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeCollection;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.project.ProjectCollection;
import com.microsoft.tfs.core.clients.workitem.query.BatchReadParameter;
import com.microsoft.tfs.core.clients.workitem.query.BatchReadParameterCollection;
import com.microsoft.tfs.core.clients.workitem.query.InvalidQueryTextException;
import com.microsoft.tfs.core.clients.workitem.query.Query;
import com.microsoft.tfs.core.clients.workitem.query.StoredQuery;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemCollection;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolder;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;
import com.microsoft.tfs.core.internal.db.ConnectionConfiguration;
import com.microsoft.tfs.core.pguidance.IProcessGuidance;
import com.microsoft.tfs.core.pguidance.internal.WSSProcessGuidance;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Closable;
import com.microsoft.tfs.util.GUID;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap;

public final class WorkItemClient
implements Closable {
    private final WorkItemEventEngine eventEngine = new WorkItemEventEngine();
    private final _ClientService2Soap webService2;
    private final _ClientService3Soap webService3;
    private final _ClientService5Soap webService5;
    private final TFSTeamProjectCollection connection;
    private ProjectCollection projectCollection;
    private FieldDefinitionCollection fieldDefinitions;
    private WorkItemLinkTypeCollection linkTypes;
    private HashMap<String, GroupDataProvider> mapGroupDataProviders;
    private WITContext witContext;
    private WorkItemServerVersion version;

    public WorkItemClient(TFSTeamProjectCollection connection, _ClientService2Soap webService2, _ClientService3Soap webService3, _ClientService5Soap webService5) {
        Check.notNull(connection, "connection");
        Check.notNull(webService2, "webService2");
        this.connection = connection;
        this.webService2 = webService2;
        this.webService3 = webService3;
        this.webService5 = webService5;
        this.detectVersion();
    }

    public boolean supportsWorkItemLinkTypes() {
        return this.version.getValue() >= WorkItemServerVersion.V3.getValue();
    }

    public boolean supportsReadOnlyLinkTypes() {
        return this.version.getValue() >= WorkItemServerVersion.V3.getValue();
    }

    public boolean supportsLinkQueries() {
        return this.version.getValue() >= WorkItemServerVersion.V3.getValue();
    }

    public boolean supportsWIQLFieldAndGroupOperators() {
        return this.version.getValue() >= WorkItemServerVersion.V3.getValue();
    }

    public boolean supportsWebAccessWorkItems() {
        return this.version.getValue() >= WorkItemServerVersion.V3.getValue();
    }

    public boolean supportsWIQLEvaluationOnServer() {
        return this.getContext().getServerInfo().isSupported("WiqlEvaluationOnServer");
    }

    private void detectVersion() {
        String location8 = this.connection.getServerDataProvider().locationForCurrentConnection("WorkitemService8", ServiceInterfaceIdentifiers.WORK_ITEM_8);
        String location5 = this.connection.getServerDataProvider().locationForCurrentConnection("WorkitemService5", ServiceInterfaceIdentifiers.WORK_ITEM_5);
        String location3 = this.connection.getServerDataProvider().locationForCurrentConnection("WorkitemService3", ServiceInterfaceIdentifiers.WORK_ITEM_3);
        this.version = location8 != null ? WorkItemServerVersion.V8 : (location5 != null ? WorkItemServerVersion.V5 : (location3 != null ? WorkItemServerVersion.V3 : WorkItemServerVersion.V1));
    }

    public File getDatabaseDirectory() {
        return this.getContext().getConnectionConfiguration().getDatabaseDiskDirectory();
    }

    public Properties getDatabaseConfigurationDebugInfo(Locale locale) {
        ConnectionConfiguration config = this.getContext().getConnectionConfiguration();
        Properties props = new Properties();
        props.setProperty(Messages.getString("WorkItemClient.DebugInfoDriver", locale), config.getDriverClass());
        props.setProperty(Messages.getString("WorkItemClient.DebugInfoURL", locale), config.getURL());
        props.setProperty(Messages.getString("WorkItemClient.DebugInfoUsername", locale), config.getUsername());
        props.setProperty(Messages.getString("WorkItemClient.DebugInfoPassword", locale), config.getPassword());
        props.setProperty(Messages.getString("WorkItemClient.DebugInfoDriverVersion", locale), config.getDriverMajorVersion() + "." + config.getDriverMinorVersion());
        props.setProperty(Messages.getString("WorkItemClient.DebugInfoDriverClassURL", locale), config.getDriverClassURL().toExternalForm());
        props.setProperty(Messages.getString("WorkItemClient.DebugInfoMetadataSchemaVersion", locale), "4.0A");
        props.setProperty(Messages.getString("WorkItemClient.DebugInfoPathIdentifier", locale), config.getPathIdentifier());
        File diskDirectory = config.getDatabaseDiskDirectory();
        if (diskDirectory == null) {
            props.setProperty(Messages.getString("WorkItemClient.DebugInfoDatabaseDiskDirectory", locale), Messages.getString("WorkItemClient.DebugInfoDatabaseDiskDirectoryNotDefined", locale));
        } else {
            props.setProperty(Messages.getString("WorkItemClient.DebugInfoDatabaseDiskDirectory", locale), diskDirectory.getAbsolutePath());
        }
        return props;
    }

    public File getDatabaseDiskDirectoryForDebugInfo() {
        return this.getContext().getConnectionConfiguration().getDatabaseDiskDirectory();
    }

    public WorkItem getWorkItemByID(int id) {
        WorkItemImpl workItem = new WorkItemImpl(this.getContext());
        workItem.getFieldsInternal().addOriginalFieldValueLocal(-3, new Integer(id), true);
        try {
            workItem.open();
        }
        catch (DeniedOrNotExistException ex) {
            return null;
        }
        return workItem;
    }

    public void deleteWorkItemByID(int id) {
        DestroyWorkItemUpdatePackage updatePackage = new DestroyWorkItemUpdatePackage(id, this.getContext());
        updatePackage.update();
    }

    public void deleteWorkItemType(String projectName, String workItemTypeName) {
        Check.notNull(projectName, "projectName");
        Check.notNull(workItemTypeName, "workItemTypeName");
        DestroyWorkItemTypeUpdatePackage updatePackage = new DestroyWorkItemTypeUpdatePackage(projectName, workItemTypeName, this.getContext());
        updatePackage.update();
        this.refreshCache();
    }

    public WorkItemServerVersion getVersion() {
        return this.version;
    }

    public _ClientService2Soap getWebService2() {
        return this.webService2;
    }

    public _ClientService3Soap getWebService3() {
        return this.webService3;
    }

    public _ClientService5Soap getWebService5() {
        return this.webService5;
    }

    public void precacheData() {
        this.getContext();
    }

    public void refreshCache() {
        this.getContext().getMetadataUpdateHandler().update();
    }

    public synchronized ProjectCollection getProjects() {
        if (this.projectCollection == null) {
            this.projectCollection = new ProjectCollectionImpl(this.getContext());
        }
        return this.projectCollection;
    }

    public GroupDataProvider getGroupDataProvider(String projectName) {
        if (this.mapGroupDataProviders == null) {
            this.mapGroupDataProviders = new HashMap();
        }
        if (!this.mapGroupDataProviders.containsKey(projectName)) {
            this.mapGroupDataProviders.put(projectName, new GroupDataProvider(this, projectName));
        }
        return this.mapGroupDataProviders.get(projectName);
    }

    public String[] getGlobalAndProjectGroups(GUID serverGuid, GUID projectGuid) {
        return this.witContext.getMetadata().getConstantsTable().getUserGroupDisplayNames(serverGuid.getGUIDString(GUID.GUIDStringFormat.DASHED), projectGuid.getGUIDString(GUID.GUIDStringFormat.DASHED));
    }

    @Override
    public void close() {
        if (this.witContext != null) {
            this.witContext.shutdown();
        }
    }

    synchronized WITContext getContext() {
        if (this.witContext == null) {
            this.witContext = new WITContext(this);
            this.witContext.getMetadataUpdateHandler().addMetadataChangeListener(new IMetadataChangeListener(){

                @Override
                public void metadataChanged(Set<String> tableNames) {
                    WorkItemClient.this.metadataChangedCallback(tableNames);
                }
            });
        }
        return this.witContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void metadataChangedCallback(Set<String> tableNames) {
        WorkItemClient workItemClient = this;
        synchronized (workItemClient) {
            if (this.projectCollection != null) {
                for (Project project : this.projectCollection) {
                    project.clearCachedWITMetadata();
                }
            }
            this.projectCollection = null;
            this.fieldDefinitions = null;
            this.linkTypes = null;
            this.mapGroupDataProviders = null;
        }
    }

    public WorkItem newWorkItem(WorkItemType inputType) {
        WorkItemImpl workItem = new WorkItemImpl(this.getContext());
        this.getContext().initNewWorkItem(workItem, inputType);
        workItem.open();
        return workItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldDefinitionCollection getFieldDefinitions() {
        WorkItemClient workItemClient = this;
        synchronized (workItemClient) {
            if (this.fieldDefinitions == null) {
                this.fieldDefinitions = new FieldDefinitionCollectionImpl(false, this.getContext(), null);
            }
            return this.fieldDefinitions;
        }
    }

    public RegisteredLinkTypeCollection getRegisteredLinkTypes() {
        return new RegisteredLinkTypeCollectionImpl(this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItemLinkTypeCollection getLinkTypes() {
        WorkItemClient workItemClient = this;
        synchronized (workItemClient) {
            if (this.linkTypes == null) {
                this.linkTypes = new WorkItemLinkTypeCollectionImpl(this.getContext());
            }
            return this.linkTypes;
        }
    }

    public String getUpdateXMLForDebugging(WorkItem workItem) {
        return ((WorkItemImpl)workItem).getUpdateXMLForDebugging();
    }

    public TFSTeamProjectCollection getConnection() {
        return this.connection;
    }

    public StoredQuery getStoredQuery(GUID guid) {
        return this.getContext().getQueryProvider().getQuery(guid);
    }

    public Query createReferencingQuery(String artifactUri) {
        ArtifactID.checkURIIsWellFormed(artifactUri);
        String[] referencingWorkItems = this.version.getValue() <= 2 ? this.getWebService2().getReferencingWorkitemUris(artifactUri) : (this.version.getValue() == 3 ? this.getWebService3().getReferencingWorkitemUris(artifactUri) : this.getWebService5().getReferencingWorkitemUris(artifactUri));
        BatchReadParameterCollection batchReadParams = new BatchReadParameterCollection();
        if (referencingWorkItems != null) {
            for (int i = 0; i < referencingWorkItems.length; ++i) {
                int id = Integer.parseInt(referencingWorkItems[i]);
                batchReadParams.add(new BatchReadParameter(id));
            }
        }
        return this.createQuery("select [System.Id] from workitems", batchReadParams);
    }

    public Query createQuery(String wiql, Map<String, Object> queryContext) throws InvalidQueryTextException {
        return new QueryImpl(this.getContext(), wiql, queryContext);
    }

    public Query createQuery(String wiql) throws InvalidQueryTextException {
        return new QueryImpl(this.getContext(), wiql);
    }

    public Query createQuery(String wiql, BatchReadParameterCollection batchReadParams) throws InvalidQueryTextException {
        return new QueryImpl(this.getContext(), wiql, batchReadParams);
    }

    public Query createEmptyQuery() {
        return new NullQueryImpl(this.getContext());
    }

    public WorkItemCollection query(String wiql, Map<String, Object> queryContext, boolean dayPrecision) throws InvalidQueryTextException {
        return new QueryImpl(this.getContext(), wiql, queryContext, dayPrecision).runQuery();
    }

    public WorkItemCollection query(String wiql, Map<String, Object> queryContext) throws InvalidQueryTextException {
        return new QueryImpl(this.getContext(), wiql, queryContext).runQuery();
    }

    public WorkItemCollection query(int[] ids, String wiql) throws InvalidQueryTextException {
        return new QueryImpl(this.getContext(), wiql, ids, null).runQuery();
    }

    public WorkItemCollection query(String wiql) throws InvalidQueryTextException {
        return new QueryImpl(this.getContext(), wiql).runQuery();
    }

    public WorkItemCollection query(String wiql, BatchReadParameterCollection batchReadParams) throws InvalidQueryTextException {
        return new QueryImpl(this.getContext(), wiql, batchReadParams).runQuery();
    }

    public void validateWIQL(String wiql) throws InvalidQueryTextException {
        StoredQueryImpl.validateWIQL(this.getContext(), wiql);
    }

    public IProcessGuidance getProcessGuidance() {
        return new WSSProcessGuidance(this.getConnection());
    }

    public static QueryFolder getDefaultParent(Project project, boolean isPublic) {
        QueryItem[] roots = project.getQueryHierarchy().getItems();
        for (int i = 0; i < roots.length; ++i) {
            if (!(roots[i] instanceof QueryFolder) || roots[i].isPersonal() != !isPublic) continue;
            return (QueryFolder)roots[i];
        }
        return null;
    }

    public UserDisplayMode getUserDisplayMode() {
        int displayMode = this.getContext().getMetadata().getUserDisplayMode();
        if (displayMode == 1) {
            return UserDisplayMode.ACCOUNT_NAME;
        }
        return UserDisplayMode.FRIENDLY_NAME;
    }

    public String getUserDisplayName() {
        if (UserDisplayMode.ACCOUNT_NAME == this.getUserDisplayMode()) {
            return this.getConnection().getAuthorizedAccountName();
        }
        return this.getConnection().getAuthorizedIdentity().getDisplayName();
    }

    public WorkItemEventEngine getEventEngine() {
        return this.eventEngine;
    }
}

