/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.clients.workitem.internal.link.LinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.RegisteredLinkTypeImpl;
import com.microsoft.tfs.core.clients.workitem.link.Hyperlink;
import com.microsoft.tfs.core.clients.workitem.link.Link;
import com.microsoft.tfs.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class HyperlinkImpl
extends LinkImpl
implements Hyperlink {
    private final String location;

    public HyperlinkImpl(String location, String comment, int extId, boolean newComponent, boolean readOnly) {
        super(new RegisteredLinkTypeImpl("Workitem Hyperlink"), comment, extId, newComponent, readOnly);
        if (location == null || location.trim().length() == 0) {
            throw new IllegalArgumentException("location must not be null or empty");
        }
        this.validateTextMaxLength(location.trim(), "location", 2083);
        this.location = location.trim();
        this.setDescription(location);
    }

    @Override
    public LinkImpl cloneLink() {
        return new HyperlinkImpl(this.location, this.getComment(), -1, true, this.isReadOnly());
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public boolean isEquivalent(Link link) {
        if (link instanceof HyperlinkImpl) {
            HyperlinkImpl other = (HyperlinkImpl)link;
            return this.location.equalsIgnoreCase(other.location);
        }
        return false;
    }

    @Override
    protected void createXMLForAdd(Element parentElement) {
        Element element = DOMUtils.appendChild(parentElement, "InsertResourceLink");
        element.setAttribute("FieldName", "System.LinkedFiles");
        element.setAttribute("Location", this.location);
        if (this.getComment() != null && this.getComment().trim().length() > 0) {
            element.setAttribute("Comment", this.getComment().trim());
        }
    }

    @Override
    protected void createXMLForRemove(Element parentElement) {
        Element element = DOMUtils.appendChild(parentElement, "RemoveResourceLink");
        element.setAttribute("LinkID", String.valueOf(this.getExtID()));
    }

    @Override
    protected String getInsertTagName() {
        return "InsertResourceLink";
    }
}

