/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;

public class NodeTableName
extends NodeItem {
    private Object tag;

    public NodeTableName(NodeName nodeName) {
        super(NodeType.TABLE_NAME, nodeName.getValue());
        this.setStartOffset(nodeName.getStartOffset());
        this.setEndOffset(nodeName.getEndOffset());
    }

    public NodeTableName(String s) {
        super(NodeType.TABLE_NAME, s);
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        if (e != null) {
            this.tag = e.findTable(this.getValue());
            Tools.ensureSyntax(this.tag != null, SyntaxError.TABLE_DOES_NOT_EXIST, this);
        }
        super.bind(e, tableContext, fieldContext);
    }

    @Override
    public void appendTo(StringBuffer b) {
        Tools.AppendName(b, this.getValue());
    }

    @Override
    public DataType getDataType() {
        return DataType.TABLE;
    }

    @Override
    public boolean isConst() {
        return true;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object obj) {
        this.tag = obj;
    }
}

