/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.types;

import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPSerializationException;
import com.microsoft.tfs.core.ws.runtime.serialization.AttributeSerializable;
import com.microsoft.tfs.core.ws.runtime.serialization.ElementSerializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class Enumeration
implements ElementSerializable,
AttributeSerializable {
    protected final String name;

    protected Enumeration(String name, Map valuesToInstances) {
        this.name = name;
        valuesToInstances.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static Enumeration fromString(String value, Map valuesToInstances) throws SOAPSerializationException {
        Enumeration ret = (Enumeration)valuesToInstances.get(value);
        if (ret == null) {
            String messageFormat = "No enumeration matches the attribute value {0}";
            String message = MessageFormat.format("No enumeration matches the attribute value {0}", value);
            throw new SOAPSerializationException(message);
        }
        return ret;
    }

    public void readFromAttribute(String value) throws XMLStreamException {
        String messageFormat = "{0} does not implement readFromAttribute because of its instance-restricted design";
        String message = MessageFormat.format("{0} does not implement readFromAttribute because of its instance-restricted design", Enumeration.class.getName());
        throw new XMLStreamException(message);
    }

    public void readFromElement(XMLStreamReader reader) throws XMLStreamException {
        String messageFormat = "{0} does not implement readFromElement because of its instance-restricted design";
        String message = MessageFormat.format("{0} does not implement readFromElement because of its instance-restricted design", Enumeration.class.getName());
        throw new XMLStreamException(message);
    }

    @Override
    public void writeAsAttribute(XMLStreamWriter writer, String name) throws XMLStreamException {
        writer.writeAttribute(name, this.toString());
    }

    @Override
    public void writeAsElement(XMLStreamWriter writer, String name) throws XMLStreamException {
        writer.writeStartElement(name);
        writer.writeCharacters(this.toString());
        writer.writeEndElement();
    }
}

