/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.decoder.entry;

import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedEntryDescriptor;
import com.microsoft.tfs.jni.appleforked.stream.decoder.entry.AppleForkedEntryDecoder;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.chunkingcodec.ByteArrayChunkedDecoder;
import java.io.File;

public class AppleForkedFinderInfoDecoder
extends ByteArrayChunkedDecoder
implements AppleForkedEntryDecoder {
    private String filename;
    private byte[] finderInfo;

    public AppleForkedFinderInfoDecoder(AppleForkedEntryDescriptor descriptor, File file) {
        super((int)descriptor.getLength());
        Check.isTrue(descriptor.getType() == 9L, "descriptor.getType() == AppleForkedConstants.ID_FINDERINFO");
        Check.notNull(file, "file");
        try {
            this.filename = file.getCanonicalPath();
        }
        catch (Exception e) {
            this.filename = file.getAbsolutePath();
        }
    }

    @Override
    protected void finish(byte[] buffer) {
        this.finderInfo = buffer;
    }

    @Override
    public void close() {
        if (this.filename != null && this.finderInfo != null && this.finderInfo.length > 0) {
            FileSystemUtils.getInstance().setMacExtendedAttribute(this.filename, "com.apple.FinderInfo", this.finderInfo);
        }
    }
}

