/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.chunkingcodec;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.chunkingcodec.ChunkedDecoder;
import java.io.IOException;
import java.io.OutputStream;

public class StreamChunkedDecoder
implements ChunkedDecoder {
    private OutputStream stream;
    private long bufferSize = 0L;
    private long bufferLen = 0L;
    private boolean complete = false;

    protected StreamChunkedDecoder() {
    }

    protected StreamChunkedDecoder(OutputStream stream, long bufferSize) {
        Check.notNull(stream, "stream");
        Check.isTrue(bufferSize >= 0L, "bufferSize >= 0");
        this.stream = stream;
        this.bufferSize = bufferSize;
    }

    protected void setBufferSize(long bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected void setStream(OutputStream stream) {
        Check.notNull(stream, "stream");
        this.stream = stream;
    }

    @Override
    public final int decode(byte[] buf, int off, int len) throws IOException {
        if (this.stream == null) {
            throw new IOException("Decoder not initialized");
        }
        int writeLen = Math.min((int)(this.bufferSize - this.bufferLen), len);
        this.stream.write(buf, off, writeLen);
        this.bufferLen += (long)writeLen;
        if (this.bufferLen == this.bufferSize) {
            this.complete = true;
            this.finish();
            this.stream.close();
        }
        return writeLen;
    }

    @Override
    public final boolean isComplete() {
        return this.complete;
    }

    protected void finish() {
    }

    public void close() throws IOException {
        this.finish();
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

