/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.base;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class ThrowExceptionCheckBase
extends CheckImplementationBase {
    private static final int GROUP_NAME = 0;
    private static final TokenPattern THROW_NEW_PATTERN = new TokenPattern().sequence(ETokenType.THROW).sequence(ETokenType.NEW).sequence(ETokenType.IDENTIFIER, new TokenPattern().repeated(ETokenType.DOT, ETokenType.IDENTIFIER)).group(0).sequence(ETokenType.LPAREN);

    @Override
    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType(this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (entity.getSubtype().equals("lambda") || this.skipMethod(entity)) {
            return;
        }
        this.processTokens((List<IToken>)entity.includedTokens());
    }

    protected TokenPattern getFindingPattern() {
        return THROW_NEW_PATTERN;
    }

    private void processTokens(List<IToken> tokens) throws CheckException {
        TokenPattern pattern = this.getFindingPattern();
        for (TokenPatternMatch match : pattern.findAll(tokens)) {
            IToken exceptionToken;
            String exceptionName;
            List<IToken> matchedTokens = match.groupTokens(0);
            if (matchedTokens.isEmpty() || !this.createFindingForException(matchedTokens, exceptionName = (exceptionToken = (IToken)CollectionUtils.getLast(matchedTokens)).getText())) continue;
            this.buildFinding(this.getFindingMessage(matchedTokens) + exceptionName, this.buildLocation().forToken(exceptionToken)).createAndStore();
        }
    }

    public abstract boolean skipMethod(ShallowEntity var1);

    protected abstract String getFindingMessage(List<IToken> var1);

    public abstract boolean createFindingForException(List<IToken> var1, String var2) throws CheckException;
}

