/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.preprocessor.swift.SwiftCompilerControlStatements;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class ConditionalCompilationClauses {
    private static final Logger LOGGER = LogManager.getLogger();

    ConditionalCompilationClauses() {
    }

    public static @NonNull List<ClauseInfo> extractClauses(@NonNull List<IToken> tokens, int startIndex) {
        Preconditions.checkElementIndex((int)startIndex, (int)tokens.size(), (String)"Start tokenIndex must be within token list");
        Preconditions.checkArgument((boolean)SwiftCompilerControlStatements.isIf(tokens.get(startIndex)), (Object)"Start tokenIndex must point to an '#if' token");
        ArrayList<ClauseInfo> clauseInfos = new ArrayList<ClauseInfo>();
        int index = startIndex;
        do {
            List<IToken> conditionTokens = ConditionalCompilationClauses.extractClauseCondition(tokens, index);
            clauseInfos.add(new ClauseInfo(tokens.get(index), index, conditionTokens, index + conditionTokens.size() + 1));
        } while ((index = ConditionalCompilationClauses.findIndexOfNextClause(tokens, index)) >= 0);
        return clauseInfos;
    }

    public static Optional<String> validateClauses(@Nullable List<ClauseInfo> infos) {
        if (CollectionUtils.isNullOrEmpty(infos)) {
            return Optional.of("Empty conditional compilation block");
        }
        ClauseInfo first = infos.get(0);
        ClauseInfo last = infos.get(infos.size() - 1);
        if (!SwiftCompilerControlStatements.isIf(first.token)) {
            return Optional.of("Invalid first clause '%s' at lines %d-%d".formatted(first.token.getText(), first.token.getLineNumber() + 1, last.token.getLineNumber() + 1));
        }
        if (!SwiftCompilerControlStatements.isEndif(last.token)) {
            return Optional.of("Missing '#endif' at lines %s-%s".formatted(first.token.getLineNumber() + 1, last.token.getLineNumber() + 1));
        }
        List<IToken> tokens = infos.stream().map(ClauseInfo::token).toList();
        long elseCount = tokens.stream().filter(SwiftCompilerControlStatements::isElse).count();
        if (elseCount > 1L) {
            return Optional.of("Multiple '#else' clauses at lines %d-%d".formatted(first.token.getLineNumber() + 1, last.token.getLineNumber() + 1));
        }
        if (elseCount == 1L && infos.size() >= 3) {
            ClauseInfo preLast = infos.get(infos.size() - 2);
            if (!SwiftCompilerControlStatements.isElse(preLast.token)) {
                return Optional.of("Misplaced '#else' clause at lines %d-%d".formatted(first.token.getLineNumber() + 1, last.token.getLineNumber() + 1));
            }
        }
        if (tokens.stream().filter(SwiftCompilerControlStatements::isIf).count() > 1L) {
            return Optional.of("Multiple '#if' clauses at lines %d-%d".formatted(first.token.getLineNumber() + 1, last.token.getLineNumber() + 1));
        }
        return Optional.empty();
    }

    private static int findIndexOfNextClause(@NonNull List<IToken> tokens, int directiveTokenIndex) {
        Preconditions.checkArgument((boolean)SwiftCompilerControlStatements.isConditional(tokens.get(directiveTokenIndex)));
        if (SwiftCompilerControlStatements.isEndif(tokens.get(directiveTokenIndex))) {
            return -1;
        }
        int tokensSize = tokens.size();
        int nesting = 0;
        for (int index = directiveTokenIndex + 1; index < tokensSize; ++index) {
            IToken token = tokens.get(index);
            if (!SwiftCompilerControlStatements.isConditional(token)) continue;
            if (SwiftCompilerControlStatements.isIf(token)) {
                ++nesting;
                continue;
            }
            if (nesting == 0) {
                return index;
            }
            if (!SwiftCompilerControlStatements.isEndif(token)) continue;
            --nesting;
        }
        return -1;
    }

    private static @NonNull List<IToken> extractClauseCondition(@NonNull List<IToken> tokens, int directiveTokenIndex) {
        Preconditions.checkElementIndex((int)(directiveTokenIndex + 1), (int)tokens.size(), (String)"Start directiveTokenIndex+1 must be within token list");
        int index = directiveTokenIndex + 1;
        boolean foundEnd = false;
        int tokenSize = tokens.size();
        while (index < tokenSize) {
            IToken token = tokens.get(index);
            if (token.getType() == ETokenType.LPAREN) {
                int closingIndex;
                if ((closingIndex = TokenStreamUtils.findMatchingClosingToken(tokens, ++index, ETokenType.LPAREN, ETokenType.RPAREN)) < index || closingIndex >= tokenSize) break;
                index = closingIndex + 1;
                continue;
            }
            if (token.getType() == ETokenType.EOL) {
                foundEnd = true;
                ++index;
                break;
            }
            ++index;
        }
        if (!foundEnd) {
            IToken directiveToken = tokens.get(directiveTokenIndex);
            LOGGER.error("Could not extract clause condition of conditional compilation block: '{}' at '{}:{}'. Attempting to continue, but processing may be incomplete.", (Object)directiveToken.getText(), (Object)directiveToken.getOriginId(), (Object)(directiveToken.getLineNumber() + 1));
            return Collections.emptyList();
        }
        return tokens.subList(directiveTokenIndex + 1, index);
    }

    public record ClauseInfo(@NonNull IToken token, int tokenIndex, @NonNull List<IToken> conditionTokens, int indexAfter) {
        @Override
        public String toString() {
            return "ClauseInfo{token=" + this.token.getText() + "@" + (this.token.getLineNumber() + 1) + ", tokenIndex=" + this.tokenIndex + ", conditionTokens=[" + StringUtils.escapeChars((String)TokenStreamTextUtils.concatTokenTexts(this.conditionTokens), (Map)StringUtils.ESCAPE_NEWLINE) + "], indexAfter=" + this.indexAfter + "}";
        }
    }
}

