/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.kotlin;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.kotlin.EKotlinParserStates;
import eu.cqse.check.framework.shallowparser.languages.kotlin.KotlinStatementSubRecognizer;
import java.util.Arrays;
import java.util.List;

public class KotlinShallowParser
extends ShallowParserBase<EKotlinParserStates> {
    private static final ITokenMatcher MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ABSTRACT, ETokenType.FINAL, ETokenType.OPEN, ETokenType.ANNOTATION, ETokenType.SEALED, ETokenType.DATA, ETokenType.OVERRIDE, ETokenType.LATEINIT, ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.INTERNAL, ETokenType.IN, ETokenType.OUT, ETokenType.NOINLINE, ETokenType.INNER, ETokenType.EXPECT, ETokenType.ACTUAL, ETokenType.CROSSINLINE, ETokenType.VARARG, ETokenType.REIFIED, ETokenType.TAILREC, ETokenType.OPERATOR, ETokenType.INFIX, ETokenType.INLINE, ETokenType.EXTERNAL, ETokenType.CONST, ETokenType.SUSPEND, ETokenType.COMPANION, ETokenType.VALUE});
    private static final ITokenMatcher KEYWORD_OR_IDENTIFIER = MODIFIERS.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.VARARG, ETokenType.FIELD, ETokenType.IT, ETokenType.BY, ETokenType.CATCH, ETokenType.CONSTRUCTOR, ETokenType.DELEGATE, ETokenType.DYNAMIC, ETokenType.ENUM, ETokenType.FIELD, ETokenType.FILE, ETokenType.FINALLY, ETokenType.GET, ETokenType.IMPORT, ETokenType.INIT, ETokenType.PARAM, ETokenType.PROPERTY, ETokenType.RECEIVER, ETokenType.SET, ETokenType.SETPARAM, ETokenType.TRY, ETokenType.WHERE})});
    private static final ITokenMatcher STATEMENT_START_TOKENS = KEYWORD_OR_IDENTIFIER.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RETURN, ETokenType.BREAK, ETokenType.CONTINUE, ETokenType.THROW, ETokenType.SUPER, ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.BOOLEAN_LITERAL, ETokenType.STRING_LITERAL, ETokenType.NULL_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.CHARACTER_LITERAL, ETokenType.IT, ETokenType.FIELD, ETokenType.MINUS, ETokenType.THIS})});
    static final ITokenMatcher VALID_INSIDE_GENERIC_TOKEN_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.QUESTION, ETokenType.DOT, ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.ARROW, ETokenType.COMMA, ETokenType.ANY, ETokenType.IN, ETokenType.OUT, ETokenType.MULT});
    private static final ITokenMatcher VALID_TYPE_TOKEN_TYPES = VALID_INSIDE_GENERIC_TOKEN_TYPES.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LT, ETokenType.GT})});
    private static final List<ETokenType> OPENING_BRACKETS = Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE);
    private static final List<ETokenType> CLOSING_BRACKETS = Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE);

    public KotlinShallowParser() {
        super(EKotlinParserStates.class, EKotlinParserStates.TOP_LEVEL);
        this.createMetaRules();
        this.createTypeRules();
        this.createMethodRules();
        this.createStatementRules();
        this.createSubExpressionRules();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.EOL});
    }

    private void createMetaRules() {
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT}).markStart().skipBefore(new ITokenMatcher[]{ETokenType.EOL}).createNode(EShallowEntityType.META, "import", INameResolver.ofRange(0, -1)).endNode();
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.PACKAGE}).markStart().skipBefore(new ITokenMatcher[]{ETokenType.EOL}).createNode(EShallowEntityType.META, "package", INameResolver.ofRange(0, -1)).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.AT, KEYWORD_OR_IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, KEYWORD_OR_IDENTIFIER}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, "annotation", INameResolver.secondMatchedTokenText()).endNode();
    }

    private void createStatementRules() {
        this.createLoopRules();
        this.createConditionalRules();
        this.createTryCatchFinallyRules();
        this.createSimpleStatementRule();
        this.createWhenStatementRule();
        this.createLocalVariableRule(ETokenType.VAR);
        this.createLocalVariableRule(ETokenType.VAL);
        this.createLocalVariableRule(ETokenType.CONST);
    }

    private void createTryCatchFinallyRules() {
        RecognizerBase<EKotlinParserStates> tryRecognizer = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD, EKotlinParserStates.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.TRY}).sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "try");
        this.endWithBlockAndContinuation(tryRecognizer, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}));
        RecognizerBase<EKotlinParserStates> catchRecognizer = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD, EKotlinParserStates.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.CATCH}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "catch");
        this.endWithBlockAndContinuation(catchRecognizer, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}));
        RecognizerBase<EKotlinParserStates> finallyRecognizer = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD, EKotlinParserStates.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.FINALLY}).sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "finally");
        this.endWithBlock(finallyRecognizer);
    }

    private void createLoopRules() {
        this.endWithBlock(this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.WHILE}).createNode(EShallowEntityType.STATEMENT, "while").sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
        this.endWithBlock(this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.FOR}).createNode(EShallowEntityType.STATEMENT, "for").sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
        RecognizerBase doWhileRule = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DO}).createNode(EShallowEntityType.STATEMENT, "do while");
        doWhileRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE, ETokenType.WHILE}).skipAfter(new ITokenMatcher[]{ETokenType.EOL}).endNode();
        doWhileRule.repeated(new ITokenMatcher[]{ETokenType.EOL}).parseOnce(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.WHILE}).skipAfter(new ITokenMatcher[]{ETokenType.EOL}).endNode();
    }

    private void createConditionalRules() {
        this.createConditionalRule("if", new ITokenMatcher[]{ETokenType.IF});
        this.createConditionalRule("else if", new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF});
        this.createElseConditionalRule();
    }

    private void createConditionalRule(String subtype, ITokenMatcher ... matchTerms) {
        this.endWithBlockAndContinuation(this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD, EKotlinParserStates.IN_STATEMENT}).sequence(matchTerms).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.STATEMENT, subtype), (ITokenMatcher)ETokenType.ELSE);
    }

    private void createElseConditionalRule() {
        RecognizerBase recognizer = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD, EKotlinParserStates.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, "else");
        this.finishStatementRule(recognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}));
        this.finishStatementRule(recognizer.repeated(new ITokenMatcher[]{ETokenType.EOL}).optional(new ITokenMatcher[]{ETokenType.NOT}).parseOnce(EKotlinParserStates.IN_METHOD));
    }

    private void createSimpleStatementRule() {
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
        this.finishStatementRule(this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD}).sequenceBefore(STATEMENT_START_TOKENS).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText()));
    }

    private void createWhenStatementRule() {
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD, EKotlinParserStates.IN_STATEMENT}).sequence(new ITokenMatcher[]{ETokenType.WHEN}).createNode(EShallowEntityType.STATEMENT, "when").skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.createSubExpressionRecognizer()).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_WHEN).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createLocalVariableRule(ETokenType keyword) {
        RecognizerBase localVariableRule = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_METHOD, EKotlinParserStates.IN_LAMBDA}).optional(MODIFIERS).sequence(new ITokenMatcher[]{keyword}).createNode(EShallowEntityType.STATEMENT, "local variable", INameResolver.secondMatchedTokenText());
        this.finishStatementRule(localVariableRule.sequence(KEYWORD_OR_IDENTIFIER).optionalSubRecognizer(this.createReturnTypeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.EQ}));
        this.finishStatementRule(localVariableRule.skipNested(ETokenType.LPAREN, ETokenType.RPAREN).optionalSubRecognizer(this.createReturnTypeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.EQ}));
        this.finishStatementRule(localVariableRule.sequence(KEYWORD_OR_IDENTIFIER).optionalSubRecognizer(this.createReturnTypeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.BY}));
        localVariableRule.sequence(KEYWORD_OR_IDENTIFIER).optionalSubRecognizer(this.createReturnTypeRecognizer()).endNode();
    }

    private void finishStatementRule(RecognizerBase<EKotlinParserStates> statementRule) {
        this.completeStatementRule(statementRule).endNode();
    }

    private RecognizerBase<EKotlinParserStates> completeStatementRule(RecognizerBase<EKotlinParserStates> statementRule) {
        return statementRule.optionalSubRecognizer(new KotlinStatementSubRecognizer(this.createSubExpressionRecognizer(), OPENING_BRACKETS, CLOSING_BRACKETS));
    }

    private void endWithBlock(RecognizerBase<EKotlinParserStates> recognizer) {
        this.endWithBlockAndContinuation(recognizer, null);
    }

    private void endWithBlockAndContinuation(RecognizerBase<EKotlinParserStates> recognizer, ITokenMatcher continuationTokens) {
        this.endWithPossibleContinuation(recognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).repeated(new ITokenMatcher[]{ETokenType.EOL}), continuationTokens);
        this.endWithPossibleContinuation(recognizer.sequence(new ITokenMatcher[]{ETokenType.EOL}).optional(new ITokenMatcher[]{ETokenType.NOT}).parseOnce(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.EOL}), continuationTokens);
        this.endWithPossibleContinuation(recognizer.optional(new ITokenMatcher[]{ETokenType.NOT}).parseOnce(EKotlinParserStates.IN_METHOD).optional(new ITokenMatcher[]{ETokenType.EOL}), continuationTokens);
    }

    public void createTypeRules() {
        this.createEnumTypeRule();
        this.createPrimaryConstructorRule();
        this.createTypeRule(ETokenType.CLASS, "class");
        this.createTypeRule(ETokenType.INTERFACE, "interface");
        this.createTypeRule(ETokenType.OBJECT, "object");
        this.createPropertyRule(ETokenType.VAR);
        this.createPropertyRule(ETokenType.VAL);
        this.createPropertyGetterRule(ETokenType.GET);
        this.createPropertyGetterRule(ETokenType.SET);
    }

    private void createEnumTypeRule() {
        RecognizerBase<EKotlinParserStates> typeNode = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_TYPE}).optional(MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.ENUM, ETokenType.CLASS, KEYWORD_OR_IDENTIFIER}).createNode(EShallowEntityType.TYPE, "enum class", INameResolver.previousTokenText()).optionalSubRecognizer(this.createPrimaryConstructorRecognizer()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase<EKotlinParserStates> inEnumRule = typeNode.skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_ENUM);
        inEnumRule.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).parseUntil(EKotlinParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        inEnumRule.sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        typeNode.endNode();
        RecognizerBase enumLiteral = this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_ENUM}).sequence(KEYWORD_OR_IDENTIFIER).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.previousTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        enumLiteral.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        enumLiteral.endNode();
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_ENUM}).sequence(new ITokenMatcher[]{ETokenType.COMMA});
    }

    private void createPrimaryConstructorRule() {
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_PRIMARY_CONSTRUCTOR}).optional(MODIFIERS).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAR, ETokenType.VAL})).sequence(KEYWORD_OR_IDENTIFIER).createNode(EShallowEntityType.ATTRIBUTE, "property", INameResolver.previousTokenText()).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.RPAREN}), Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE)).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
    }

    private void createTypeRule(ETokenType typeTokenType, String subTypeName) {
        RecognizerBase<EKotlinParserStates> typeNodeWithEOL = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_TYPE}).repeatedAtLeastOnce(MODIFIERS).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{typeTokenType});
        RecognizerBase<EKotlinParserStates> typeNode = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_TYPE}).repeated(MODIFIERS).sequence(new ITokenMatcher[]{typeTokenType});
        this.completeTypeRule(typeNodeWithEOL, subTypeName, typeTokenType);
        this.completeTypeRule(typeNode, subTypeName, typeTokenType);
    }

    private void completeTypeRule(RecognizerBase<EKotlinParserStates> typeNode, String subTypeName, ETokenType typeTokenType) {
        INameResolver positionOfName = typeTokenType == ETokenType.OBJECT ? INameResolver.previousTokenText() : INameResolver.firstMatchedTokenText();
        typeNode = typeNode.markStart().optional(KEYWORD_OR_IDENTIFIER).skipNested(ETokenType.LT, ETokenType.GT).createNode(EShallowEntityType.TYPE, subTypeName, positionOfName);
        typeNode = typeNode.repeatedSubRecognizer(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.AT, ETokenType.IDENTIFIER}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN)));
        if (typeTokenType != ETokenType.OBJECT) {
            typeNode = typeNode.optionalSubRecognizer(this.createPrimaryConstructorRecognizer());
        }
        typeNode = typeNode.optionalSubRecognizer(this.createInheritanceRecogniser()).optionalSubRecognizer(this.createWhereRecogniser());
        typeNode.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        typeNode.endNode();
    }

    private RecognizerBase<EKotlinParserStates> createInheritanceRecogniser() {
        RecognizerBase singleSuperClassRecogniser = this.createRecognizer(start -> start.repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LT, ETokenType.GT).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.COMMA}));
        return this.createRecognizer(start -> start.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.COLON}).repeated(new ITokenMatcher[]{ETokenType.EOL}).repeatedSubRecognizer(singleSuperClassRecogniser));
    }

    private RecognizerBase<EKotlinParserStates> createWhereRecogniser() {
        RecognizerBase whereTypeRecogniser = this.createRecognizer(start -> start.repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.IDENTIFIER}).skipNested(ETokenType.LT, ETokenType.GT).optional(new ITokenMatcher[]{ETokenType.COMMA}));
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.WHERE}).repeatedSubRecognizer(whereTypeRecogniser));
    }

    private void createPropertyRule(ETokenType propertyKeyword) {
        RecognizerBase typeFollowRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LT, ETokenType.GT).sequence(new ITokenMatcher[]{ETokenType.DOT}));
        RecognizerBase<EKotlinParserStates> attributeRule = this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_TYPE}).repeated(MODIFIERS).sequence(new ITokenMatcher[]{propertyKeyword}).skipNested(ETokenType.LT, ETokenType.GT).markStart().repeatedSubRecognizer(typeFollowRecognizer).sequence(KEYWORD_OR_IDENTIFIER).createNode(EShallowEntityType.ATTRIBUTE, "property", INameResolver.ofRange(0, -1)).optionalSubRecognizer(this.createReturnTypeRecognizer());
        this.endWithPossibleGetterOrSetter(this.completeStatementRule(attributeRule.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.BY}))));
        this.endWithPossibleGetterOrSetter(attributeRule);
    }

    private void endWithPossibleGetterOrSetter(RecognizerBase<EKotlinParserStates> attributeRule) {
        attributeRule.preCondition(this.createPreGetterAndSetterPrecondition()).skipWhile((ITokenMatcher)ETokenType.EOL).parseOnce(EKotlinParserStates.IN_PROPERTY).skipWhile((ITokenMatcher)ETokenType.EOL).parseOnce(EKotlinParserStates.IN_PROPERTY).endNode();
        attributeRule.preCondition(this.createGetterOrSetterPrecondition()).skipWhile((ITokenMatcher)ETokenType.EOL).parseOnce(EKotlinParserStates.IN_PROPERTY).endNode();
        attributeRule.endNode();
    }

    private RecognizerBase<EKotlinParserStates> createGetterOrSetterPrecondition() {
        return this.createRecognizer(start -> start.skipWhile((ITokenMatcher)ETokenType.EOL).optional(MODIFIERS).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET})));
    }

    private RecognizerBase<EKotlinParserStates> createPreGetterAndSetterPrecondition() {
        return this.createRecognizer(start -> {
            RecognizerBase firstGetterSetter = start.skipWhile((ITokenMatcher)ETokenType.EOL).optional(MODIFIERS).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET}));
            firstGetterSetter.skipWhile((ITokenMatcher)ETokenType.EOL).optional(MODIFIERS).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET}));
            RecognizerBase getterSetterWithBodyRule = firstGetterSetter.sequenceBefore(new ITokenMatcher[]{ETokenType.LPAREN}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
            this.completeStatementRule(getterSetterWithBodyRule.sequence(new ITokenMatcher[]{ETokenType.EQ})).skipWhile((ITokenMatcher)ETokenType.EOL).optional(MODIFIERS).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET}));
            getterSetterWithBodyRule.sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).skipNested(ETokenType.LBRACE, ETokenType.RBRACE).skipWhile((ITokenMatcher)ETokenType.EOL).optional(MODIFIERS).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET}));
        });
    }

    private void createPropertyGetterRule(ETokenType tokenType) {
        RecognizerBase plainGetterSetterRule = this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_PROPERTY}).optional(MODIFIERS).markStart().sequence(new ITokenMatcher[]{tokenType}).createNode(EShallowEntityType.METHOD, "method", INameResolver.firstMatchedTokenText());
        RecognizerBase methodRule = plainGetterSetterRule.sequenceBefore(new ITokenMatcher[]{ETokenType.LPAREN}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        methodRule.sequence(new ITokenMatcher[]{ETokenType.EQ}).repeated(new ITokenMatcher[]{ETokenType.EOL}).parseOnce(EKotlinParserStates.IN_METHOD).endNode();
        methodRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        plainGetterSetterRule.endNode();
    }

    private RecognizerBase<EKotlinParserStates> createPrimaryConstructorRecognizer() {
        return this.createRecognizer(start -> start.optional(MODIFIERS).markStart().optional(new ITokenMatcher[]{ETokenType.CONSTRUCTOR}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).parseMultiple(EKotlinParserStates.IN_PRIMARY_CONSTRUCTOR).sequence(new ITokenMatcher[]{ETokenType.RPAREN}));
    }

    private void createMethodRules() {
        this.finishMethodRule(this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_TYPE, EKotlinParserStates.IN_METHOD}).sequence(MODIFIERS).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.FUN}).skipNested(ETokenType.LT, ETokenType.GT).markStart().skipBefore(new ITokenMatcher[]{ETokenType.LPAREN}), "method");
        this.finishMethodRule(this.inState(new EKotlinParserStates[]{EKotlinParserStates.TOP_LEVEL, EKotlinParserStates.IN_TYPE, EKotlinParserStates.IN_METHOD}).optional(MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.FUN}).skipNested(ETokenType.LT, ETokenType.GT).markStart().skipBefore(new ITokenMatcher[]{ETokenType.LPAREN}), "method");
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_TYPE}).optional(MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.INIT}).createNode(EShallowEntityType.METHOD, "constructor", INameResolver.firstMatchedTokenText()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.finishMethodRule(this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_TYPE}).optional(MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.CONSTRUCTOR}), "constructor");
    }

    private void finishMethodRule(RecognizerBase<EKotlinParserStates> rule, String subtype) {
        RecognizerBase<EKotlinParserStates> methodRule = rule.createNode(EShallowEntityType.METHOD, subtype, INameResolver.ofRange(0, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).optionalSubRecognizer(this.createReturnTypeRecognizer());
        methodRule.sequence(new ITokenMatcher[]{ETokenType.EQ}).repeated(new ITokenMatcher[]{ETokenType.EOL}).parseOnce(EKotlinParserStates.IN_METHOD).endNode();
        methodRule.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        methodRule.endNode();
    }

    private RecognizerBase<EKotlinParserStates> createReturnTypeRecognizer() {
        return this.createRecognizer(start -> {
            start.sequence(new ITokenMatcher[]{ETokenType.COLON}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SUPER, ETokenType.THIS})).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
            start.optional(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.COLON}).optional(new ITokenMatcher[]{ETokenType.EOL}).repeated(VALID_TYPE_TOKEN_TYPES).optional(new ITokenMatcher[]{ETokenType.EOL});
        });
    }

    private RecognizerBase<EKotlinParserStates> createSubExpressionRecognizer() {
        RecognizerBase<EKotlinParserStates> subExpressionRule = this.createRecognizer(start -> start.sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).parseOnce(EKotlinParserStates.IN_LAMBDA));
        subExpressionRule.sequenceBefore(new ITokenMatcher[]{ETokenType.IF}).parseOnce(EKotlinParserStates.IN_STATEMENT);
        subExpressionRule.sequenceBefore(new ITokenMatcher[]{ETokenType.TRY}).parseOnce(EKotlinParserStates.IN_STATEMENT);
        subExpressionRule.sequenceBefore(new ITokenMatcher[]{ETokenType.WHEN}).parseOnce(EKotlinParserStates.IN_STATEMENT);
        return subExpressionRule;
    }

    private void createSubExpressionRules() {
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_LAMBDA}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ARROW, ETokenType.RBRACE}), OPENING_BRACKETS, CLOSING_BRACKETS).sequence(new ITokenMatcher[]{ETokenType.ARROW}).createNode(EShallowEntityType.METHOD, "lambda").parseUntil(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_LAMBDA}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "lambda").parseUntil(EKotlinParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.LBRACE, ETokenType.IDENTIFIER, ETokenType.ARROW}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).createNode(EShallowEntityType.METHOD, "lambda").parseUntil(EKotlinParserStates.IN_METHOD).endNode();
        this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_WHEN}).sequence(new ITokenMatcher[]{ETokenType.EOL});
        this.endWithBlock(this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_WHEN}).sequence(new ITokenMatcher[]{ETokenType.ELSE, ETokenType.ARROW}).createNode(EShallowEntityType.META, "else"));
        this.endWithBlock(this.inState(new EKotlinParserStates[]{EKotlinParserStates.IN_WHEN}).skipAfterWithNesting((ITokenMatcher)ETokenType.ARROW, OPENING_BRACKETS, CLOSING_BRACKETS).createNode(EShallowEntityType.META, "case", INameResolver.firstMatchedTokenText()));
    }
}

