/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.clientapi;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.sonarsource.sonarlint.core.clientapi.client.OpenUrlInBrowserParams;
import org.sonarsource.sonarlint.core.clientapi.client.binding.AssistBindingParams;
import org.sonarsource.sonarlint.core.clientapi.client.binding.AssistBindingResponse;
import org.sonarsource.sonarlint.core.clientapi.client.binding.NoBindingSuggestionFoundParams;
import org.sonarsource.sonarlint.core.clientapi.client.binding.SuggestBindingParams;
import org.sonarsource.sonarlint.core.clientapi.client.connection.AssistCreatingConnectionParams;
import org.sonarsource.sonarlint.core.clientapi.client.connection.AssistCreatingConnectionResponse;
import org.sonarsource.sonarlint.core.clientapi.client.connection.GetCredentialsParams;
import org.sonarsource.sonarlint.core.clientapi.client.connection.GetCredentialsResponse;
import org.sonarsource.sonarlint.core.clientapi.client.event.DidReceiveServerEventParams;
import org.sonarsource.sonarlint.core.clientapi.client.fs.FindFileByNamesInScopeParams;
import org.sonarsource.sonarlint.core.clientapi.client.fs.FindFileByNamesInScopeResponse;
import org.sonarsource.sonarlint.core.clientapi.client.hotspot.ShowHotspotParams;
import org.sonarsource.sonarlint.core.clientapi.client.http.CheckServerTrustedParams;
import org.sonarsource.sonarlint.core.clientapi.client.http.CheckServerTrustedResponse;
import org.sonarsource.sonarlint.core.clientapi.client.http.GetProxyPasswordAuthenticationParams;
import org.sonarsource.sonarlint.core.clientapi.client.http.GetProxyPasswordAuthenticationResponse;
import org.sonarsource.sonarlint.core.clientapi.client.http.ProxyDto;
import org.sonarsource.sonarlint.core.clientapi.client.http.SelectProxiesParams;
import org.sonarsource.sonarlint.core.clientapi.client.http.SelectProxiesResponse;
import org.sonarsource.sonarlint.core.clientapi.client.info.GetClientInfoResponse;
import org.sonarsource.sonarlint.core.clientapi.client.issue.ShowIssueParams;
import org.sonarsource.sonarlint.core.clientapi.client.message.ShowMessageParams;
import org.sonarsource.sonarlint.core.clientapi.client.message.ShowSoonUnsupportedMessageParams;
import org.sonarsource.sonarlint.core.clientapi.client.progress.ReportProgressParams;
import org.sonarsource.sonarlint.core.clientapi.client.progress.StartProgressParams;
import org.sonarsource.sonarlint.core.clientapi.client.smartnotification.ShowSmartNotificationParams;
import org.sonarsource.sonarlint.core.clientapi.client.sync.DidSynchronizeConfigurationScopeParams;

public interface SonarLintClient {
    @JsonNotification
    public void suggestBinding(SuggestBindingParams var1);

    @JsonRequest
    public CompletableFuture<FindFileByNamesInScopeResponse> findFileByNamesInScope(FindFileByNamesInScopeParams var1);

    @JsonNotification
    public void openUrlInBrowser(OpenUrlInBrowserParams var1);

    @JsonNotification
    public void showMessage(ShowMessageParams var1);

    @JsonNotification
    public void showSoonUnsupportedMessage(ShowSoonUnsupportedMessageParams var1);

    @JsonNotification
    public void showSmartNotification(ShowSmartNotificationParams var1);

    @JsonRequest
    public CompletableFuture<GetClientInfoResponse> getClientInfo();

    @JsonNotification
    public void showHotspot(ShowHotspotParams var1);

    @JsonNotification
    public void showIssue(ShowIssueParams var1);

    public CompletableFuture<AssistCreatingConnectionResponse> assistCreatingConnection(AssistCreatingConnectionParams var1);

    @JsonRequest
    public CompletableFuture<AssistBindingResponse> assistBinding(AssistBindingParams var1);

    @JsonRequest
    public CompletableFuture<Void> startProgress(StartProgressParams var1);

    @JsonNotification
    public void reportProgress(ReportProgressParams var1);

    @JsonNotification
    public void didSynchronizeConfigurationScopes(DidSynchronizeConfigurationScopeParams var1);

    @JsonRequest
    public CompletableFuture<GetCredentialsResponse> getCredentials(GetCredentialsParams var1);

    @JsonRequest
    default public CompletableFuture<SelectProxiesResponse> selectProxies(SelectProxiesParams params) {
        List<Proxy> proxies = ProxySelector.getDefault().select(URI.create(params.getUri()));
        SelectProxiesResponse response = new SelectProxiesResponse(proxies.stream().map(SonarLintClient::convert).collect(Collectors.toList()));
        return CompletableFuture.completedFuture(response);
    }

    private static ProxyDto convert(Proxy proxy) {
        if (proxy.type() == Proxy.Type.DIRECT) {
            return ProxyDto.NO_PROXY;
        }
        InetSocketAddress address = (InetSocketAddress)proxy.address();
        String server = address.getHostString();
        int port = address.getPort();
        return new ProxyDto(proxy.type(), server, port);
    }

    @JsonRequest
    default public CompletableFuture<GetProxyPasswordAuthenticationResponse> getProxyPasswordAuthentication(GetProxyPasswordAuthenticationParams params) {
        URL targetHostUrl;
        try {
            targetHostUrl = new URL(params.getTargetHostURL());
        }
        catch (MalformedURLException e) {
            return CompletableFuture.failedFuture(e);
        }
        PasswordAuthentication passwordAuthentication = Authenticator.requestPasswordAuthentication(params.getHost(), null, params.getPort(), params.getProtocol(), params.getPrompt(), params.getScheme(), targetHostUrl, Authenticator.RequestorType.PROXY);
        GetProxyPasswordAuthenticationResponse response = new GetProxyPasswordAuthenticationResponse(passwordAuthentication != null ? passwordAuthentication.getUserName() : null, passwordAuthentication != null ? new String(passwordAuthentication.getPassword()) : null);
        return CompletableFuture.completedFuture(response);
    }

    @JsonRequest
    default public CompletableFuture<CheckServerTrustedResponse> checkServerTrusted(CheckServerTrustedParams params) {
        return CompletableFuture.completedFuture(new CheckServerTrustedResponse(false));
    }

    @JsonNotification
    default public void didReceiveServerEvent(DidReceiveServerEventParams params) {
    }

    @JsonNotification
    public void noBindingSuggestionFound(NoBindingSuggestionFoundParams var1);
}

