/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons;

import java.util.Map;
import java.util.function.BiPredicate;
import org.sonar.api.Plugin;
import org.sonar.api.config.Configuration;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.plugin.commons.container.ExtensionContainer;
import org.sonarsource.sonarlint.core.plugin.commons.sonarapi.PluginContextImpl;
import org.sonarsource.sonarlint.plugin.api.SonarLintRuntime;

public class ExtensionInstaller {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final SonarLintRuntime sonarRuntime;
    private final Configuration bootConfiguration;

    public ExtensionInstaller(SonarLintRuntime sonarRuntime, Configuration bootConfiguration) {
        this.sonarRuntime = sonarRuntime;
        this.bootConfiguration = bootConfiguration;
    }

    public ExtensionInstaller install(ExtensionContainer container, Map<String, Plugin> pluginInstancesByKey, BiPredicate<String, Object> extensionFilter) {
        for (Map.Entry<String, Plugin> pluginInstanceEntry : pluginInstancesByKey.entrySet()) {
            Plugin plugin = pluginInstanceEntry.getValue();
            Plugin.Context context = new PluginContextImpl.Builder().setSonarRuntime(this.sonarRuntime).setBootConfiguration(this.bootConfiguration).build();
            String pluginKey = pluginInstanceEntry.getKey();
            try {
                plugin.define(context);
                ExtensionInstaller.loadExtensions(container, pluginKey, context, extensionFilter);
            }
            catch (Throwable t) {
                LOG.error("Error loading components for plugin '{}'", (Object)pluginKey, (Object)t);
            }
        }
        return this;
    }

    private static void loadExtensions(ExtensionContainer container, String pluginKey, Plugin.Context context, BiPredicate<String, Object> extensionFilter) {
        for (Object extension : context.getExtensions()) {
            if (!extensionFilter.test(pluginKey, extension)) continue;
            container.addExtension(pluginKey, extension);
        }
    }
}

