/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rule.extractor;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleParamType;

public class SonarLintRuleParamDefinition {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final String key;
    private final String name;
    private final String description;
    private final String defaultValue;
    private final SonarLintRuleParamType type;
    private final boolean multiple;
    private final List<String> possibleValues;

    public SonarLintRuleParamDefinition(RulesDefinition.Param param) {
        this.key = param.key();
        this.name = param.name();
        this.description = param.description();
        this.defaultValue = param.defaultValue();
        RuleParamType apiType = param.type();
        this.type = SonarLintRuleParamDefinition.from(apiType);
        this.multiple = apiType.multiple();
        this.possibleValues = Collections.unmodifiableList(apiType.values());
    }

    private static SonarLintRuleParamType from(RuleParamType apiType) {
        try {
            return SonarLintRuleParamType.valueOf(apiType.type());
        }
        catch (IllegalArgumentException unknownType) {
            LOG.warn("Unknown parameter type: " + apiType.type());
            return SonarLintRuleParamType.STRING;
        }
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    @CheckForNull
    public String defaultValue() {
        return this.defaultValue;
    }

    public SonarLintRuleParamType type() {
        return this.type;
    }

    public boolean multiple() {
        return this.multiple;
    }

    public List<String> possibleValues() {
        return this.possibleValues;
    }
}

