/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.telemetry.InternalDebug;
import org.sonarsource.sonarlint.core.telemetry.TelemetryClientAttributesProvider;
import org.sonarsource.sonarlint.core.telemetry.TelemetryLocalStorage;
import org.sonarsource.sonarlint.core.telemetry.TelemetryUtils;
import org.sonarsource.sonarlint.core.telemetry.payload.HotspotPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.IssuePayload;
import org.sonarsource.sonarlint.core.telemetry.payload.ShowHotspotPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.ShowIssuePayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TaintVulnerabilitiesPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryAnalyzerPerformancePayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryHelpAndFeedbackPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryNotificationsPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryRulesPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.cayc.CleanAsYouCodePayload;
import org.sonarsource.sonarlint.core.telemetry.payload.cayc.NewCodeFocusPayload;

public class TelemetryHttpClient {
    public static final String TELEMETRY_ENDPOINT = "https://telemetry.sonarsource.com/sonarlint";
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final String product;
    private final String version;
    private final String ideVersion;
    private final String platform;
    private final String architecture;
    private final HttpClient client;
    private final String endpoint;

    public TelemetryHttpClient(String product, String version, String ideVersion, @Nullable String platform, @Nullable String architecture, HttpClient client) {
        this(product, version, ideVersion, platform, architecture, client, TELEMETRY_ENDPOINT);
    }

    TelemetryHttpClient(String product, String version, String ideVersion, @Nullable String platform, @Nullable String architecture, HttpClient client, String endpoint) {
        this.product = product;
        this.version = version;
        this.ideVersion = ideVersion;
        this.platform = platform;
        this.architecture = architecture;
        this.client = client;
        this.endpoint = endpoint;
    }

    void upload(TelemetryLocalStorage data, TelemetryClientAttributesProvider attributesProvider) {
        block2: {
            try {
                this.sendPost(this.createPayload(data, attributesProvider));
            }
            catch (Throwable catchEmAll) {
                if (!InternalDebug.isEnabled()) break block2;
                LOG.error("Failed to upload telemetry data", catchEmAll);
            }
        }
    }

    void optOut(TelemetryLocalStorage data, TelemetryClientAttributesProvider attributesProvider) {
        block2: {
            try {
                this.sendDelete(this.createPayload(data, attributesProvider));
            }
            catch (Throwable catchEmAll) {
                if (!InternalDebug.isEnabled()) break block2;
                LOG.error("Failed to upload telemetry opt-out", catchEmAll);
            }
        }
    }

    private TelemetryPayload createPayload(TelemetryLocalStorage data, TelemetryClientAttributesProvider attributesProvider) {
        OffsetDateTime systemTime = OffsetDateTime.now();
        long daysSinceInstallation = data.installTime().until(systemTime, ChronoUnit.DAYS);
        TelemetryAnalyzerPerformancePayload[] analyzers = TelemetryUtils.toPayload(data.analyzers());
        TelemetryNotificationsPayload notifications = TelemetryUtils.toPayload(attributesProvider.devNotificationsDisabled(), data.notifications());
        ShowHotspotPayload showHotspotPayload = new ShowHotspotPayload(data.showHotspotRequestsCount());
        ShowIssuePayload showIssuePayload = new ShowIssuePayload(data.getShowIssueRequestsCount());
        HotspotPayload hotspotPayload = new HotspotPayload(data.openHotspotInBrowserCount(), data.hotspotStatusChangedCount());
        TaintVulnerabilitiesPayload taintVulnerabilitiesPayload = new TaintVulnerabilitiesPayload(data.taintVulnerabilitiesInvestigatedLocallyCount(), data.taintVulnerabilitiesInvestigatedRemotelyCount());
        IssuePayload issuePayload = new IssuePayload(data.issueStatusChangedRuleKeys());
        String os = System.getProperty("os.name");
        String jre = System.getProperty("java.version");
        TelemetryRulesPayload telemetryRulesPayload = new TelemetryRulesPayload(attributesProvider.getNonDefaultEnabledRules(), attributesProvider.getDefaultDisabledRules(), data.getRaisedIssuesRules(), data.getQuickFixesApplied());
        TelemetryHelpAndFeedbackPayload helpAndFeedbackPayload = new TelemetryHelpAndFeedbackPayload(data.getHelpAndFeedbackLinkClickedCounter());
        CleanAsYouCodePayload cleanAsYouCodePayload = new CleanAsYouCodePayload(new NewCodeFocusPayload(data.isFocusOnNewCode(), data.getCodeFocusChangedCount()));
        return new TelemetryPayload(daysSinceInstallation, data.numUseDays(), this.product, this.version, this.ideVersion, this.platform, this.architecture, attributesProvider.usesConnectedMode(), attributesProvider.useSonarCloud(), systemTime, data.installTime(), os, jre, attributesProvider.nodeVersion().orElse(null), analyzers, notifications, showHotspotPayload, showIssuePayload, taintVulnerabilitiesPayload, telemetryRulesPayload, hotspotPayload, issuePayload, helpAndFeedbackPayload, cleanAsYouCodePayload, attributesProvider.additionalAttributes());
    }

    private void sendDelete(TelemetryPayload payload) {
        try (HttpClient.Response response = this.client.delete(this.endpoint, "application/json; charset=utf-8", payload.toJson());){
            if (!response.isSuccessful() && InternalDebug.isEnabled()) {
                LOG.error("Failed to upload telemetry opt-out: {}", (Object)response.toString());
            }
        }
    }

    private void sendPost(TelemetryPayload payload) {
        try (HttpClient.Response response = this.client.post(this.endpoint, "application/json; charset=utf-8", payload.toJson());){
            if (!response.isSuccessful() && InternalDebug.isEnabled()) {
                LOG.error("Failed to upload telemetry data: {}", (Object)response.toString());
            }
        }
    }
}

