Using `==` and `!=` can lead to inconsistent behavior and may hinder performance.
Prefer using `===` and `!==` for comparisons.

# What Does This Check Look For?

This check identifies occurrences where `==` or `!=` operators are used for comparisons in the code.

# Why is This a Problem?

The use of `==` and `!=` for comparison can lead to unexpected results because these operators perform type coercion, potentially causing two values to be considered equal even if they are of different types.
This behavior can introduce bugs and make the code harder to understand.
Furthermore, `===` and `!==`, which do not perform type coercion, not only prevent these issues but also offer better performance.

# How Can I Resolve This?

Replace `==` with `===` and `!=` with `!==` in your comparisons.
This makes the code more predictable and safer by preventing unintended type coercions.

# Examples

## Non-Compliant

```javascript
if(a == b) { 
  // non-compliant: May lead to unintended behavior
}
```

```javascript
if(a != b) { 
  // non-compliant: May lead to unintended behavior
}
```

## Compliant

```javascript
if(a === b) { 
  // compliant: Ensures strict equality without type coercion
}
```

```javascript
if(a !== b) { 
  // compliant: Ensures strict inequality without type coercion
}
```

# Where Can I Learn More?

- [MDN Web Docs: Equality comparisons and sameness](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Equality_comparisons_and_sameness)
- [JavaScript Info: Comparison operators](https://javascript.info/comparison)