Losing the original exception's stacktrace makes identifying the root cause more challenging.
When throwing a new exception after catching an earlier one, include the caught exception in the new exception's constructor.

# What Does This Check Look For?

This check looks for situations where an exception is caught, but when a new exception is thrown, the original exception is not included in the constructor of the new exception. This results in the loss of the original stack trace.

# Why is This a Problem?

Preserving the original stack trace of an exception is critical for diagnosing and troubleshooting errors effectively.
Without the original stack trace, developers may find it challenging to understand the context and the sequence of events leading up to an error, which can significantly increase the time required to debug and fix issues.
Moreover, the loss of crucial debugging information compromises the application's maintainability and can lead to prolonged downtimes in production environments.
Therefore, ensuring that exception handling mechanisms conserve the full error context by maintaining the stack trace is essential for timely resolution of problems and improving the overall quality and reliability of software.

# How Can I Resolve This?

To resolve this, when catching and re-throwing an exception, ensure to pass the originally caught exception to the constructor of the new exception.
This action retains the original stacktrace, making the path leading to the error transparent and aiding in quicker debugging and error resolution.

# Examples

## Non-Compliant

```java
try {
    someRiskyOperation();
} catch (InitialException e) {
    throw new DifferentException("Something went wrong");
}
```

## Compliant

```java
try {
    someRiskyOperation();
} catch (InitialException e) {
    throw new DifferentException("Something went wrong", e);
}
```

# Where Can I Learn More?

- [Oracle Java Documentation: Chained Exceptions](https://docs.oracle.com/javase/tutorial/essential/exceptions/chained.html)
- Effective Java 3rd Edition, Joshua Bloch - Item 73: Throw exceptions appropriate to the abstractions