# Description
Make messages easy to find

# Extended Information
All messages must be statically referenced exactly once

Only `MESSAGE` and `RAISE` statments are counted as static references

Also see rule "message_exists"

https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#make-messages-easy-to-find

# Clean ABAP Code Style Guide
To make messages easy to find through a where-used search from transaction SE91, use the following pattern:

```ABAP
MESSAGE e001(ad) INTO DATA(message).
```

In case variable `message` is not needed, add the pragma `##NEEDED`:

```ABAP
MESSAGE e001(ad) INTO DATA(message) ##NEEDED.
```

Avoid the following:

```ABAP
" anti-pattern
IF 1 = 2. MESSAGE e001(ad). ENDIF.
```

This is an anti-pattern since:
- It contains unreachable code.
- It tests a condition which can never be true for equality.

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/easy_to_find_messages) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
