# Description
Use `line_exists`, from 740sp02 and up

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#prefer-line_exists-to-read-table-or-loop-at

Not reported if the `READ TABLE` statement contains `BINARY SEARCH`.

# Examples
**Bad example**
```abap
READ TABLE my_table TRANSPORTING NO FIELDS WITH KEY key = 'A'.
IF sy-subrc = 0.
ENDIF.
```

**Good example**
```abap
IF line_exists( my_table[ key = 'A' ] ).
ENDIF.
```

# Clean ABAP Code Style Guide
```ABAP
IF line_exists( my_table[ key = 'A' ] ).
```

expresses the intent clearer and shorter than

```ABAP
" anti-pattern
READ TABLE my_table TRANSPORTING NO FIELDS WITH KEY key = 'A'.
IF sy-subrc = 0.
```

or even

```ABAP
" anti-pattern
LOOP AT my_table REFERENCE INTO DATA(line) WHERE key = 'A'.
  line_exists = abap_true.
  EXIT.
ENDLOOP.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/use_line_exists) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
