Ensures that there are no duplicate input properties or output event listeners

- Type: problem

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<input [name]="foo" [name]="bar">
       ~~~~~~~~~~~~ ~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [name]="foo" name="bar">
       ~~~~~~~~~~~~ ~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input name="foo" name="bar">
       ~~~~~~~~~~ ~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input (change)="foo($event)" (change)="bar($event)">
       ~~~~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [(ngModel)]="model" [(ngModel)]="otherModel">
       ~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [name]="foo" [other]="bam" [name]="bar">
       ~~~~~~~~~~~~               ~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [name]="foo" [name]="bar" [name]="bam">
       ~~~~~~~~~~~~ ~~~~~~~~~~~~ ~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [(ngModel)]="model" [name]="foo" [(ngModel)]="otherModel" name="bar">
       ~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~~~ ~~~~~~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input (@fade.start)="animationStarted($event)" (@fade.start)="animationStarted($event)">
       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input (window:resize)="windowResized($event)" (resize)="resize()" (window:resize)="windowResized2($event)">
       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [(ngModel)]="model" (ngModelChange)="modelChanged()">
       ~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [name]="foo" class="css-static" name="bar" [class]="dynamic">
       ~~~~~~~~~~~~                    ~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input class="foo" class="bar" [class]="dynamic">
       ~~~~~~~~~~~ ~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input style="color: blue" [style]="styleExpression" style="width:50px">
       ~~~~~~~~~~~~~~~~~~~                           ~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<input name="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input [name]="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input (change)="bar()">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input [(ngModel)]="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input [(ngModel)]="model" (ngModelChange)="modelChanged()">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div (@fade.start)="animationStarted($event)" (@fade.done)="animationDone($event)"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div (window:keydown)="windowKeydown($event)" (document:keydown)="documentKeydown($event)" (document:keyup)="documentKeyup($event)" (keyup)="keyup($event)" (keydown)="keydown($event)"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div [style.width.px]="col.width" [width]="col.width"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button [class.disabled]="!enabled" [disabled]="!enabled"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button [@.disabled]="!enabled" [.disabled]="!enabled"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div [style.width]="col.width + 'px'" [width]="col.width"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div class="foo" name="bar" [class]="dynamic"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div style="color: blue" [style]="styleExpression"></div>
```

</details>
