﻿## SA1111

<table>
<tr>
  <td>TypeName</td>
  <td>SA1111ClosingParenthesisMustBeOnLineOfLastParameter</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1111</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The closing parenthesis or bracket in a call to a C# method or indexer, or the declaration of a method or indexer, is not placed on the same line as the last parameter.

## Rule description

A violation of this rule occurs when the closing bracket of a method or indexer call or declaration is not placed on the same line as the last parameter. The following examples show correct placement of the bracket:

```csharp
public string JoinName(string first, string last)
{
    string name = JoinStrings(
        first, 
        last);
}

public int this[int x]
{
    get { return this.items[x]; }
}
```

## How to fix violations

To fix a violation of this rule, ensure that the closing bracket is placed on the same line as the last parameter.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1111:ClosingParenthesisMustBeOnLineOfLastParameter", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1111 // ClosingParenthesisMustBeOnLineOfLastParameter
#pragma warning restore SA1111 // ClosingParenthesisMustBeOnLineOfLastParameter
```
