﻿## SA1620

<table>
<tr>
  <td>TypeName</td>
  <td>SA1620GenericTypeParameterDocumentationMustMatchTypeParameters</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1620</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The `<typeparam>` tags within the Xml header documentation for a generic C# element do not match the generic type parameters on the element.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs if the `<typeparam>` tags within the element's header documentation do not match the generic type parameters on the element, or do not appear in the same order as the element's type parameters.

## How to fix violations

To fix a violation of this rule, add and fill-in one `<typeparam>` tag for each generic type parameter on the element, and make sure that the `<typeparam>` tags appear in the same order as the element's type parameters.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// A sample generic class.
/// </summary>
/// <typeparam name="S">The first generic type parameter.</typeparam>
/// <typeparam name="T">The second generic type parameter.</typeparam>
public class Class1<S, T>
{ 
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1620:GenericTypeParameterDocumentationMustMatchTypeParameters", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1620 // GenericTypeParameterDocumentationMustMatchTypeParameters
#pragma warning restore SA1620 // GenericTypeParameterDocumentationMustMatchTypeParameters
```
