﻿## SA1638

<table>
<tr>
  <td>TypeName</td>
  <td>SA1638FileHeaderFileNameDocumentationMustMatchFileName</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1638</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The file tag within the file header at the top of a C# code file does not contain the name of the file.

## Rule description

A violation of this rule occurs when the file tag within the file header at the top of a C# file does not contain the name of the file. For example, consider a C# source file named File1.cs, with the following header:

```csharp
//-----------------------------------------------------------------------
// <copyright file="File2.cs" company="My Company">
//     Custom company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

A violation of this rule would occur, since the file tag does not contain the correct name of the file. The header should be written as:

```csharp
//-----------------------------------------------------------------------
// <copyright file="File1.cs" company="My Company">
//     Custom company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

## How to fix violations

To fix a violation of this rule, add the name of the file to the file tag.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1638:FileHeaderFileNameDocumentationMustMatchFileName", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1638 // FileHeaderFileNameDocumentationMustMatchFileName
#pragma warning restore SA1638 // FileHeaderFileNameDocumentationMustMatchFileName
```
