<h2>Why is this an issue?</h2>
<p>ECMAScript 2015 introduced the ability to extract and assign multiple data points from an object or array simultaneously. This is called
"destructuring", and it allows you to condense boilerplate code so you can concentrate on logic.</p>
<p>This rule raises an issue when multiple pieces of data are extracted out of the same object or array and assigned to variables.</p>
<h3>Noncompliant code example</h3>

```js
function foo (obj1, obj2, array) {
  var a = obj1.a;  // Noncompliant
  var b = obj1.b;

  var name = obj2.name;  // ignored; there's only one extraction-and-assignment

  var zero = array[0];  // Noncompliant
  var one = array[1];
}
```
<h3>Compliant solution</h3>

```js
function foo (obj1, obj2, array) {
  var {a, b} = obj1;

  var {name} = obj2;  // this syntax works because var name and property name are the same

  var [zero, one] = array;
}
```