<h2>Why is this an issue?</h2>
<p>The <code>&lt;object&gt;</code> HTML element represents an external resource, which can be treated as an image, a nested browsing context, or a
resource to be handled by a plugin. The element’s children are the fallback content. This allows multiple object elements to be nested inside each
other, targeting multiple user agents with different capabilities, with the user agent picking the first one it supports.</p>
<p>Assistive technologies, such as screen readers, will not be able to render <code>&lt;object&gt;</code> elements, in such cases it is the content of
the <code>&lt;object&gt;</code> which is provided to the user. This alternative content needs to be accessible or the screen readers won’t be able to
use it. For example, if an <code>&lt;img&gt;</code> is used it must contain an <code>alt</code> attribute.</p>
<p>This rule raises an issue when an <code>&lt;object&gt;</code> tag does not have any alternative content.</p>

```js
<object></object> <!-- Noncompliant -->

<object>
  <object></object> <!-- Noncompliant -->
</object>
```
<p>Provide alternative content to <code>&lt;object&gt;</code> elements.</p>

```js
<object>This application shows the simulation of two particles colliding</object>

<object>
  <img src="flower.png" alt="Flower growing in a pot" />
</object>

<object>
  <object>
    This application shows the simulation of two particles colliding
  </object>
</object>
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://www.w3.org/TR/WCAG20-TECHS/H53.html">WCAG2, H53</a> - Using the body of the object element </li>
  <li> <a href="https://www.w3.org/WAI/WCAG21/quickref/?versions=2.0#qr-text-equiv-all">WCAG2, 1.1.1</a> - Non-text Content </li>
  <li> <a href="https://www.w3.org/WAI/WCAG21/quickref/?versions=2.0#qr-media-equiv-audio-desc">WCAG2, 1.2.3</a> - Audio Description or Media
  Alternative (Prerecorded) </li>
  <li> <a href="https://www.w3.org/WAI/WCAG21/quickref/?versions=2.0#qr-media-equiv-text-doc">WCAG2, 1.2.8</a> - Media Alternative (Prerecorded) </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> Web:ImgWithoutAltCheck </li>
</ul>