<h2>Why is this an issue?</h2>
<p>An empty function is generally considered bad practice and can lead to confusion, readability, and maintenance issues. Empty functions bring no
functionality and are misleading to others as they might think the function implementation fulfills a specific and identified requirement.</p>
<p>There are several reasons for a function not to have a body:</p>
<ul>
  <li> It is an unintentional omission, and should be fixed to prevent an unexpected behavior in production. </li>
  <li> It is not yet, or never will be, supported. In this case an exception should be thrown. </li>
  <li> The method is an intentionally-blank override. In this case a nested comment should explain the reason for the blank override. </li>
</ul>
<h3>Exceptions</h3>
<p>This rule doesn’t raise an issue on empty methods in abstract classes.</p>

```php
abstract class Animal {
  public function speak() {}  // default implementation ignored
}
```
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
public function shouldNotBeEmpty() {  // Noncompliant - method is empty
}

public function notImplemented() {  // Noncompliant - method is empty
}

public function emptyOnPurpose() {  // Noncompliant - method is empty
}
```
<h4>Compliant solution</h4>

```php
public function shouldNotBeEmpty() {
  doSomething();
}

public function notImplemented() {
  throw new Exception('notImplemented() cannot be performed because ...');
}

public function emptyOnPurpose() {
  // comment explaining why the method is empty
}
```