<p>The <code>enable_dl</code> PHP configuration setting allows PHP extensions to be loaded dynamically at runtime.</p>
<h2>Why is this an issue?</h2>
<p>When dynamic loading is enabled, PHP code can load arbitrary PHP extensions by calling the <code>dl</code> function. This can be used to bypass
restrictions set with the <code>open_basedir</code> configuration.</p>
<p>PHP defaults to allowing dynamic loading.</p>
<h2>How to fix it</h2>
<p><code>enable_dl</code> setting should be set to <code>0</code> in the main PHP configuration.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
; php.ini
enable_dl=1  ; Noncompliant
```
<h4>Compliant solution</h4>

```php
; php.ini
enable_dl=0
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A05_2021-Security_Misconfiguration/">Top 10 2021 Category A5 - Security Misconfiguration</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A6_2017-Security_Misconfiguration">Top 10 2017 Category A6 - Security
  Misconfiguration</a> </li>
</ul>