<h2>Why is this an issue?</h2>
<p>The <code>for...in</code> statement allows you to loop through the names of all of the properties of an object. The list of properties includes all
those properties that were inherited through the prototype chain. This has the side effect of serving up functions when the interest is in data
properties. Programs that don’t take this into account can fail.</p>
<p>Therefore, the body of every <code>for...in</code> statement should be wrapped in an <code>if</code> statement that filters which properties are
acted upon. It can select for a particular type or range of values, or it can exclude functions, or it can exclude properties from the prototype.</p>
<h3>Noncompliant code example</h3>

```ts
for (name in object) {
    doSomething(name);  // Noncompliant
}
```
<h3>Compliant solution</h3>

```ts
for (name in object) {
  if (object.hasOwnProperty(name)) {
    doSomething(name);
  }
}
```
<h3>Exceptions</h3>
<p>Loops used to clone objects are ignored.</p>

```ts
for (prop in obj) {
  a[prop] = obj[prop];  // Compliant by exception
}
```