<h2>Why is this an issue?</h2>
<p>The <code>delete</code> operator can be used to remove a property from any object. Arrays are objects, so the <code>delete</code> operator can be
used on them too.</p>
<p>When you delete an element from an array using the <code>delete</code> keyword, it will remove the value but still leave behind an empty slot at
that index. Therefore, a hole will be created in the array because the indexes won’t be shifted to reflect the deletion. This means that the array
will still have that index, but the value will be <code>undefined</code>.</p>
<p>Arrays that have gaps or missing indexes between elements are known as sparse arrays.</p>

```ts
let myArray = ['a', 'b', 'c', 'd'];

delete myArray[2]; // Noncompliant: myArray => ['a', 'b', undefined, 'd']
console.log(myArray[2]); // expected value was 'd' but output is undefined
```
<p>The proper method for removing an element from an array should be one of the following:</p>
<ul>
  <li> <code>Array.prototype.splice()</code> - removes element(s) from an array at certain indexe(s) </li>
  <li> <code>Array.prototype.pop()</code> - removes the last element from an array </li>
  <li> <code>Array.prototype.shift()</code> - removes the first element from an array </li>
</ul>
<p>Note that these methods mutate arrays in-place. Alternatively, you could create new arrays using copying methods and exclude the element you want
to remove.</p>

```ts
let myArray = ['a', 'b', 'c', 'd'];

// removes 1 element from index 2
removed = myArray.splice(2, 1);  // myArray => ['a', 'b', 'd']
console.log(myArray[2]); // outputs 'd'
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/delete">delete operator</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Indexed_collections#sparse_arrays">Sparse arrays</a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/delete#deleting_array_elements">Deleting
  array elements</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array#copying_methods_and_mutating_methods">Copying methods
  and mutating methods</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/pop">Array.prototype.pop()</a>
  </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/shift">Array.prototype.shift()</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice">Array.prototype.splice()</a> </li>
</ul>